/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Build;
import android.widget.TextView;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;

public class FontUtils {
    private static final String ROBOTO_MEDIUM = "fonts/intercom_roboto_medium.ttf";
    private static final Twig twig = LumberMill.getLogger();

    public static void setRobotoMediumTypeface(TextView textView) {
        if (Build.VERSION.SDK_INT >= 21) {
            textView.setTypeface(Typeface.create((String)"sans-serif-medium", (int)0));
        } else {
            try {
                AssetManager assets = textView.getContext().getAssets();
                textView.setTypeface(Typeface.createFromAsset((AssetManager)assets, (String)ROBOTO_MEDIUM));
            }
            catch (RuntimeException ignored) {
                twig.e("We could not load our custom font, using the default system font as a backup.", new Object[0]);
            }
        }
    }

    public static void setRobotoLightTypeface(TextView textView) {
        if (Build.VERSION.SDK_INT >= 16) {
            textView.setTypeface(Typeface.create((String)"sans-serif-light", (int)0));
        } else {
            textView.setTypeface(Typeface.SANS_SERIF);
        }
    }
}

