/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.utilities.NullSafety;

public class EventParticipant
implements Parcelable {
    private final String id;
    private final String initial;
    private final String label;
    private final String type;
    private final Avatar avatar;
    public static final EventParticipant NULL = new EventParticipant(new Builder());
    public static final Parcelable.Creator<EventParticipant> CREATOR = new Parcelable.Creator<EventParticipant>(){

        public EventParticipant createFromParcel(Parcel in) {
            return new EventParticipant(in);
        }

        public EventParticipant[] newArray(int size) {
            return new EventParticipant[size];
        }
    };

    private EventParticipant(Builder builder) {
        this.id = NullSafety.valueOrEmpty(builder.id);
        this.initial = NullSafety.valueOrEmpty(builder.initial);
        this.label = NullSafety.valueOrEmpty(builder.label);
        this.type = NullSafety.valueOrEmpty(builder.type);
        this.avatar = builder.avatar == null ? new Avatar.Builder().build() : builder.avatar.build();
    }

    public String getId() {
        return this.id;
    }

    public String getInitial() {
        return this.initial;
    }

    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.type;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    protected EventParticipant(Parcel in) {
        this.id = in.readString();
        this.initial = in.readString();
        this.label = in.readString();
        this.type = in.readString();
        this.avatar = (Avatar)in.readValue(Avatar.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.initial);
        dest.writeString(this.label);
        dest.writeString(this.type);
        dest.writeValue((Object)this.avatar);
    }

    public static final class Builder {
        @Nullable
        String id;
        @Nullable
        String initial;
        @Nullable
        String label;
        @Nullable
        String type;
        @Nullable
        Avatar.Builder avatar;

        public EventParticipant build() {
            return new EventParticipant(this);
        }
    }
}

