/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.support.annotation.Nullable;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.android.sdk.nexus.NexusTopicProvider;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.okhttp3.OkHttpClient;
import io.intercom.okhttp3.Request;
import io.intercom.okhttp3.Response;
import io.intercom.okhttp3.WebSocket;
import io.intercom.okhttp3.WebSocketListener;
import io.intercom.okio.ByteString;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class NexusSocket {
    private static final int OK_CLIENT_DISCONNECT = 4000;
    private static final int N_TIMEOUT_DISCONNECT = 4001;
    private static final int MAX_RECONNECT_TIME_SECONDS = 900;
    private static final String HEADER = "?X-Nexus-Version=android.5.1.0";
    private final NexusListener listener;
    private final NexusTopicProvider topicProvider;
    private final ScheduledExecutorService timeoutExecutor;
    private final OkHttpClient client;
    private final Twig twig;
    private final String url;
    private final long connectionTimeoutSeconds;
    private final boolean shouldSendPresence;
    private WebSocket socket = CLOSED_SOCKET;
    @Nullable
    private ScheduledFuture reconnectFuture;
    @Nullable
    private ScheduledFuture timeoutFuture;
    private final Runnable timeoutRunnable = new Runnable(){

        @Override
        public void run() {
            NexusSocket.this.timedOut();
        }
    };
    private long lastReconnectAt = 0L;
    private int reconnectAttempts = 0;
    private final WebSocketListener webSocketListener = new WebSocketListener(){

        @Override
        public void onOpen(WebSocket webSocket, Response response) {
            NexusSocket.this.twig.internal("onOpen: " + response.message());
            NexusSocket.this.socket = webSocket;
            NexusSocket.this.resetTimeout();
            List<String> topics = NexusSocket.this.topicProvider.getTopics();
            if (!topics.isEmpty()) {
                NexusSocket.this.fire(NexusEvent.getSubscribeEvent(topics).toStringEncodedJsonObject());
            }
            if (NexusSocket.this.shouldSendPresence) {
                NexusSocket.this.fire(NexusEvent.getUserPresenceEvent().toStringEncodedJsonObject());
            }
            NexusSocket.this.listener.onConnect();
        }

        @Override
        public void onMessage(WebSocket webSocket, String text) {
            NexusSocket.this.resetTimeout();
            this.parseJsonString(text);
        }

        private void parseJsonString(String content) {
            if (content.isEmpty() || content.equals(" ") || content.endsWith("|")) {
                return;
            }
            try {
                JSONObject json = new JSONObject(content);
                String eventName = json.optString("eventName");
                if (eventName.isEmpty() || eventName.equals("ACK")) {
                    NexusSocket.this.twig.internal("onMessage ACK: " + content);
                } else {
                    NexusSocket.this.twig.internal("onMessage TEXT: " + content);
                    NexusSocket.this.listener.notifyEvent(new NexusEvent(json));
                }
            }
            catch (JSONException e) {
                NexusSocket.this.twig.internal("onMessage: json parse exception for message: '" + content + " " + (Object)((Object)e));
            }
        }

        @Override
        public void onMessage(WebSocket webSocket, ByteString bytes) {
            NexusSocket.this.twig.internal("Received bytes message " + bytes + ", resetting timeout");
            NexusSocket.this.resetTimeout();
        }

        @Override
        public void onClosing(WebSocket webSocket, int code, String reason) {
            NexusSocket.this.twig.internal("Server requested close:  " + code + " - '" + reason + "'");
            webSocket.close(code, reason);
        }

        @Override
        public void onClosed(WebSocket webSocket, int code, String reason) {
            switch (code) {
                case 4000: {
                    NexusSocket.this.shutdown();
                    break;
                }
                default: {
                    NexusSocket.this.scheduleReconnect();
                }
            }
            NexusSocket.this.twig.internal("onClose code: " + code + " reason: " + reason);
        }

        @Override
        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            if (NexusSocket.shouldReconnectFromFailure(response)) {
                NexusSocket.this.scheduleReconnect();
            } else {
                NexusSocket.this.shutdown();
            }
            NexusSocket.this.twig.internal("onFailure: " + t.getMessage());
            NexusSocket.this.listener.onConnectFailed();
        }
    };
    private static final WebSocket CLOSED_SOCKET = new WebSocket(){

        @Override
        public Request request() {
            throw new NullPointerException("ClosedSocket has no request");
        }

        @Override
        public long queueSize() {
            return 0L;
        }

        @Override
        public boolean send(String text) {
            return false;
        }

        @Override
        public boolean send(ByteString bytes) {
            return false;
        }

        @Override
        public boolean close(int code, String reason) {
            return false;
        }

        @Override
        public void cancel() {
        }
    };

    NexusSocket(String url, int connectionTimeoutSeconds, boolean shouldSendPresence, Twig twig, ScheduledExecutorService timeoutExecutor, OkHttpClient client, NexusListener listener, NexusTopicProvider topicProvider) {
        this.url = url;
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        this.shouldSendPresence = shouldSendPresence;
        this.twig = twig;
        this.listener = listener;
        this.topicProvider = topicProvider;
        this.client = client;
        this.timeoutExecutor = timeoutExecutor;
    }

    void connect() {
        this.twig.d("connecting to a socket...", new Object[0]);
        Request request = new Request.Builder().url(this.url + HEADER).build();
        this.client.newWebSocket(request, this.webSocketListener);
        this.timeoutFuture = this.timeoutExecutor.schedule(this.timeoutRunnable, this.connectionTimeoutSeconds, TimeUnit.SECONDS);
    }

    void fire(String data) {
        if (data.isEmpty()) {
            return;
        }
        try {
            this.twig.internal("firing: " + data);
            this.socket.send(data);
        }
        catch (IllegalStateException e) {
            this.twig.internal("Error when firing '" + data + "': " + e);
        }
    }

    void disconnect() {
        this.disconnect(4000, "Disconnect called by client");
    }

    boolean isConnected() {
        return this.socket != CLOSED_SOCKET;
    }

    private void disconnect(int code, String reason) {
        boolean closedSuccessfully = this.socket.close(code, reason);
        if (!closedSuccessfully) {
            this.twig.internal("Could not close socket while disconnecting, it may be already closed");
        }
    }

    private void timedOut() {
        if (this.socket == CLOSED_SOCKET) {
            this.scheduleReconnect();
        } else {
            this.disconnect(4001, "Socket timed out");
        }
        this.listener.onConnectFailed();
    }

    private void resetTimeout() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(true);
        }
        this.timeoutFuture = this.timeoutExecutor.schedule(this.timeoutRunnable, this.connectionTimeoutSeconds, TimeUnit.SECONDS);
    }

    private void scheduleReconnect() {
        if (this.reconnectFuture != null) {
            return;
        }
        this.modifyReconnectAttempts();
        long delay = NexusSocket.calculateReconnectTimerInSeconds(this.reconnectAttempts);
        this.twig.internal("Scheduling reconnect in: " + delay + " for attempt: " + this.reconnectAttempts);
        this.reconnectFuture = this.timeoutExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                NexusSocket.this.connect();
                NexusSocket.this.reconnectFuture = null;
            }
        }, delay, TimeUnit.SECONDS);
    }

    private void modifyReconnectAttempts() {
        long maxReconnectTimeIncludingJitter;
        long millisSinceLastAttempt = System.currentTimeMillis() - this.lastReconnectAt;
        if (millisSinceLastAttempt > (maxReconnectTimeIncludingJitter = TimeUnit.SECONDS.toMillis(900L) * 2L)) {
            this.twig.d("resetting reconnection attempts", new Object[0]);
            this.reconnectAttempts = 1;
        } else {
            this.twig.d("incrementing reconnection attempts", new Object[0]);
            ++this.reconnectAttempts;
        }
        this.lastReconnectAt = System.currentTimeMillis();
    }

    private void shutdown() {
        this.socket = CLOSED_SOCKET;
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(true);
        }
        this.listener.onShutdown();
    }

    static long calculateReconnectTimerInSeconds(int reconnectAttempts) {
        int minimumBackoffSeconds = (int)Math.min(Math.pow(2.0, reconnectAttempts), 900.0);
        int jitter = new Random().nextInt(minimumBackoffSeconds + 1);
        return minimumBackoffSeconds + jitter;
    }

    static boolean shouldReconnectFromFailure(@Nullable Response response) {
        if (response != null) {
            int statusCode = response.code();
            return statusCode >= 500 && statusCode <= 599;
        }
        return true;
    }
}

