/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.push.PushPayload;
import io.intercom.android.sdk.push.SystemNotificationFactory;
import io.intercom.android.sdk.twig.Twig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SystemNotificationManager {
    private static final int NOTIFICATION_ID = 9999997;
    @VisibleForTesting
    final List<PushPayload> receivedPayloads = Collections.synchronizedList(new ArrayList());
    private final Twig twig = LumberMill.getLogger();
    private final SystemNotificationFactory systemNotificationFactory;
    private final NotificationManager androidNotificationManager;
    static final String CHAT_REPLIES_CHANNEL = "intercom_chat_replies_channel";
    static final String NEW_CHATS_CHANNEL = "intercom_new_chats_channel";
    static final String ACTIONS_CHANNEL = "intercom_actions_channel";

    public SystemNotificationManager(NotificationManager androidNotificationManager) {
        this(androidNotificationManager, new SystemNotificationFactory());
    }

    @VisibleForTesting
    SystemNotificationManager(NotificationManager androidNotificationManager, SystemNotificationFactory systemNotificationFactory) {
        this.androidNotificationManager = androidNotificationManager;
        this.systemNotificationFactory = systemNotificationFactory;
        if (Build.VERSION.SDK_INT >= 26) {
            this.setUpNotificationChannels();
        }
    }

    @TargetApi(value=26)
    private void setUpNotificationChannels() {
        NotificationChannel repliesChannel = new NotificationChannel(CHAT_REPLIES_CHANNEL, (CharSequence)"Chat replies", 4);
        repliesChannel.setDescription("Reply notifications from chats in this app");
        this.androidNotificationManager.createNotificationChannel(repliesChannel);
        NotificationChannel newChatsChannel = new NotificationChannel(NEW_CHATS_CHANNEL, (CharSequence)"New chats", 4);
        newChatsChannel.setDescription("New chat messages sent from this app");
        this.androidNotificationManager.createNotificationChannel(newChatsChannel);
        NotificationChannel actionsChannel = new NotificationChannel(ACTIONS_CHANNEL, (CharSequence)"Actions", 4);
        actionsChannel.setDescription("Contain links to take an action in this app");
        this.androidNotificationManager.createNotificationChannel(actionsChannel);
    }

    public void clear() {
        if (!this.receivedPayloads.isEmpty()) {
            this.twig.i("Removing Intercom push notifications.", new Object[0]);
        }
        this.androidNotificationManager.cancel(9999997);
        this.receivedPayloads.clear();
    }

    void createPushOnlyNotification(PushPayload payload, Context context) {
        Notification notification = this.systemNotificationFactory.createPushOnlyNotification(payload, context);
        String pushOnlyConversationId = payload.getPushOnlyConversationId();
        this.androidNotificationManager.notify(pushOnlyConversationId, pushOnlyConversationId.hashCode(), notification);
    }

    void createNotification(PushPayload payload, Context context, AppConfig appConfig) {
        if (this.receivedPayloads.contains(payload)) {
            return;
        }
        this.receivedPayloads.add(payload);
        Notification notification = this.receivedPayloads.size() == 1 ? this.systemNotificationFactory.createSingleNotification(payload, context, appConfig) : this.systemNotificationFactory.createGroupedNotification(this.receivedPayloads, context);
        this.androidNotificationManager.notify(9999997, notification);
    }
}

