/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.profile.ProfilePresenter;
import java.util.UUID;

public class MetricTracker {
    static final String NAME_MV3_METRIC = "mv3_metric";
    static final String NAME_EDUCATE_METRIC = "educate_event";
    static final String ACTION_OPENED = "opened";
    static final String ACTION_CLOSED = "closed";
    static final String ACTION_TYPED = "typed";
    static final String ACTION_SENT = "sent";
    static final String ACTION_RECEIVED = "received";
    static final String ACTION_VIEWED = "viewed";
    static final String ACTION_DISMISSED = "dismissed";
    static final String ACTION_SEARCHED = "searched";
    static final String ACTION_CLICKED = "clicked";
    static final String OBJECT_BADGE = "badge";
    static final String OBJECT_CONVERSATION_LIST = "conversation_list";
    static final String OBJECT_CONVERSATION = "conversation";
    static final String OBJECT_NEW_CONVERSATION = "new_conversation";
    static final String OBJECT_MESSENGER = "messenger";
    static final String OBJECT_MESSAGE = "message";
    static final String OBJECT_REPLY = "reply";
    static final String OBJECT_REACTION = "reaction";
    static final String OBJECT_TEAMMATE_PROFILE = "teammate_profile";
    static final String OBJECT_TEAM_PROFILE = "team_profile";
    static final String OBJECT_ARTICLE = "article";
    static final String OBJECT_EXPANDED_GIF_INPUT = "expanded_gif_input";
    static final String OBJECT_EXPANDED_IMAGE_INPUT = "expanded_image_input";
    static final String OBJECT_TEXT_INPUT = "text_input";
    static final String OBJECT_GIF_INPUT = "gif_input";
    static final String OBJECT_IMAGE_INPUT = "image_input";
    static final String PLACE_MESSENGER = "messenger";
    static final String PLACE_IN_APP = "in_app";
    static final String PLACE_PUSH = "push";
    static final String CONTEXT_FROM_LAUNCHER = "from_launcher";
    static final String CONTEXT_FROM_CUSTOM_LAUNCHER = "from_custom_launcher";
    static final String CONTEXT_FROM_ANDROID_BACK_BUTTON = "from_android_back_button";
    static final String CONTEXT_FROM_CLOSE_BUTTON = "from_close_button";
    static final String CONTEXT_FROM_CONVERSATION_LIST = "from_conversation_list";
    static final String CONTEXT_IN_NEW_CONVERSATION = "in_new_conversation";
    static final String CONTEXT_FROM_NEW_CONVERSATION = "from_new_conversation";
    static final String CONTEXT_FROM_CONVERSATION = "from_conversation";
    static final String CONTEXT_IN_CONVERSATION = "in_conversation";
    static final String CONTEXT_FROM_SNIPPET = "from_snippet";
    static final String CONTEXT_FROM_FULL = "from_full";
    static final String CONTEXT_FROM_CLICKING = "from_clicking";
    static final String CONTEXT_FROM_SCROLLING = "from_scrolling";
    static final String CONTEXT_FROM_AUTO = "from_auto";
    static final String CONTEXT_FROM_PUSH = "from_push";
    static final String CONTEXT_ON_ARTICLE = "on_article";
    static final String METADATA_BADGE_VALUE = "badge_value";
    static final String METADATA_IS_ATTACHMENT = "is_attachment";
    static final String METADATA_IS_GIF = "is_gif";
    static final String METADATA_MESSAGE_ID = "message_id";
    static final String METADATA_CONVERSATION_ID = "conversation_id";
    static final String METADATA_COMMENT_ID = "comment_id";
    static final String METADATA_REACTION_INDEX = "reaction_index";
    static final String METADATA_MESSAGE_TYPE = "message_type";
    static final String METADATA_PUSH_TYPE = "push_type";
    static final String METADATA_HAS_ARTICLE_CARD = "has_article_card";
    static final String METADATA_SEARCH_QUERY = "search_query";
    static final String METADATA_TEAMMATE_STATUS = "teammate_status";
    static final String METADATA_TIME_SINCE_LAST_ACTIVE = "time_since_last_active";
    static final String METADATA_WITHIN_OFFICE_HOURS = "within_office_hours";
    static final String METADATA_IS_ANNOTATED = "is_annotated";
    static final String VALUE_MESSAGE = "message";
    static final String VALUE_NOTIFICATION = "notification";
    static final String VALUE_ACTIVE = "active";
    static final String VALUE_AWAY = "away";
    static final String OWNER_MESSENGER = "messenger";
    static final String OWNER_EDUCATE = "educate";
    private final UserIdentity userIdentity;
    private final TimeProvider timeProvider;
    private final MetricsStore store;

    public MetricTracker(UserIdentity userIdentity, MetricsStore store) {
        this(userIdentity, store, TimeProvider.SYSTEM);
    }

    @VisibleForTesting
    MetricTracker(UserIdentity userIdentity, MetricsStore store, TimeProvider timeProvider) {
        this.userIdentity = userIdentity;
        this.timeProvider = timeProvider;
        this.store = store;
    }

    public void openedMessengerConversationList(LauncherOpenBehaviour.LauncherType launcherType) {
        String fromContext = LauncherOpenBehaviour.LauncherType.DEFAULT == launcherType ? CONTEXT_FROM_LAUNCHER : CONTEXT_FROM_CUSTOM_LAUNCHER;
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION_LIST, "messenger", fromContext));
    }

    public void openedMessengerConversation(String conversationId, LauncherOpenBehaviour.LauncherType launcherType) {
        String fromContext = LauncherOpenBehaviour.LauncherType.DEFAULT == launcherType ? CONTEXT_FROM_LAUNCHER : CONTEXT_FROM_CUSTOM_LAUNCHER;
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION, "messenger", fromContext).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openedMessengerNewConversation(LauncherOpenBehaviour.LauncherType launcherType) {
        String fromContext = LauncherOpenBehaviour.LauncherType.DEFAULT == launcherType ? CONTEXT_FROM_LAUNCHER : CONTEXT_FROM_CUSTOM_LAUNCHER;
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_NEW_CONVERSATION, "messenger", fromContext));
    }

    public void closedMessengerBackButton() {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_CLOSED, "messenger", "messenger", CONTEXT_FROM_ANDROID_BACK_BUTTON));
    }

    public void closedMessengerCloseButton() {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_CLOSED, "messenger", "messenger", CONTEXT_FROM_CLOSE_BUTTON));
    }

    public void newConversationFromComposeButton(boolean withinOfficeHours) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_NEW_CONVERSATION, "messenger", CONTEXT_FROM_CONVERSATION_LIST).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours));
    }

    void typeInNewConversation() {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_TYPED, "message", "messenger", CONTEXT_IN_NEW_CONVERSATION));
    }

    void typeInConversation(String conversationId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_TYPED, OBJECT_REPLY, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void sentInNewConversation(boolean isAttachment, boolean isAnnotated, boolean isGif, String partId, String conversationId, boolean withinOfficeHours) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_SENT, "message", "messenger", CONTEXT_IN_NEW_CONVERSATION).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_IS_ANNOTATED, isAnnotated).addMetaData(METADATA_IS_GIF, isGif).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours));
    }

    public void sentInConversation(boolean isAttachment, boolean isAnnotated, boolean isGif, String partId, String conversationId, boolean withinOfficeHours, boolean isTeamMateActive, String timeSinceLastActive) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_SENT, OBJECT_REPLY, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_IS_ANNOTATED, isAnnotated).addMetaData(METADATA_IS_GIF, isGif).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours).addMetaData(METADATA_TEAMMATE_STATUS, isTeamMateActive ? VALUE_ACTIVE : VALUE_AWAY).addMetaData(METADATA_TIME_SINCE_LAST_ACTIVE, timeSinceLastActive));
    }

    public void openConversationsListFromNewConversation() {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION_LIST, "messenger", CONTEXT_FROM_NEW_CONVERSATION));
    }

    public void startConversation(String conversationId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION, "messenger", CONTEXT_FROM_NEW_CONVERSATION).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openConversationsListFromConversation(String conversationId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION_LIST, "messenger", CONTEXT_FROM_CONVERSATION).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openedConversationFromFull(String conversationId, String commentId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION, "messenger", CONTEXT_FROM_FULL).addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openedConversationFromSnippet(String conversationId, String commentId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION, "messenger", CONTEXT_FROM_SNIPPET).addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void receivedReply(boolean isAttachment, boolean hasArticle, String partId, String conversationId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, OBJECT_REPLY, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle).addMetaData(METADATA_COMMENT_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void viewedReply(boolean isAttachment, boolean hasArticle, String partId, String conversationId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_VIEWED, OBJECT_REPLY, "messenger", CONTEXT_FROM_SNIPPET).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle).addMetaData(METADATA_COMMENT_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void sentReaction(String conversationId, String messageId, int reactionIndex, ReactionLocation reactionLocation) {
        if (ReactionLocation.CONVERSATION == reactionLocation) {
            this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_SENT, OBJECT_REACTION, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_REACTION_INDEX, reactionIndex).addMetaData(METADATA_CONVERSATION_ID, conversationId));
        } else if (ReactionLocation.LINK == reactionLocation) {
            this.store.track(this.newMetric(NAME_EDUCATE_METRIC, OWNER_EDUCATE, ACTION_SENT, OBJECT_REACTION, "messenger", CONTEXT_ON_ARTICLE).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
        } else {
            this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_SENT, OBJECT_REACTION, PLACE_IN_APP, CONTEXT_FROM_FULL).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
        }
    }

    public void profileClickedOpen(String conversationId, ProfilePresenter.ProfileType profileType) {
        String profileObject = ProfilePresenter.ProfileType.TEAMMATE == profileType ? OBJECT_TEAMMATE_PROFILE : OBJECT_TEAM_PROFILE;
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, profileObject, "messenger", CONTEXT_FROM_CLICKING).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void profileAutoOpen(String conversationId, ProfilePresenter.ProfileType profileType) {
        String profileObject = ProfilePresenter.ProfileType.TEAMMATE == profileType ? OBJECT_TEAMMATE_PROFILE : OBJECT_TEAM_PROFILE;
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, profileObject, "messenger", CONTEXT_FROM_AUTO).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void profileScrolledOpen(String conversationId, ProfilePresenter.ProfileType profileType) {
        String profileObject = ProfilePresenter.ProfileType.TEAMMATE == profileType ? OBJECT_TEAMMATE_PROFILE : OBJECT_TEAM_PROFILE;
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, profileObject, "messenger", CONTEXT_FROM_SCROLLING).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openConversationFromConversationList(String conversationId, boolean withinOfficeHours, boolean isTeamMateActive, String timeSinceLastActive) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_CONVERSATION, "messenger", CONTEXT_FROM_CONVERSATION_LIST).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours).addMetaData(METADATA_TEAMMATE_STATUS, isTeamMateActive ? VALUE_ACTIVE : VALUE_AWAY).addMetaData(METADATA_TIME_SINCE_LAST_ACTIVE, timeSinceLastActive));
    }

    public void viewedPushNotification(String conversationId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_VIEWED, "message", PLACE_IN_APP, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION));
    }

    public void openedPushOnlyNotification(String conversationId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, "message", PLACE_IN_APP, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, "message"));
    }

    public void dismissedPushNotification(String conversationId, boolean isPushOnly) {
        String pushType = isPushOnly ? "message" : VALUE_NOTIFICATION;
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_DISMISSED, "message", PLACE_IN_APP, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, pushType));
    }

    public void receivedMessageFromSnippetWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId, String messageId, String messageStyle) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, "message", PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_MESSAGE_TYPE, messageStyle).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle));
    }

    public void receivedReplyFromSnippetWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId, String commentId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, OBJECT_REPLY, PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle));
    }

    public void receivedMessageFromFullWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId, String messageId, String messageStyle) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, "message", PLACE_IN_APP, CONTEXT_FROM_FULL).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_MESSAGE_TYPE, messageStyle).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle));
    }

    public void dismissInAppMessageSnippet(String conversationId, String messageId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_DISMISSED, "message", PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId));
    }

    public void dismissInAppCommentSnippet(String conversationId, String commentId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_DISMISSED, OBJECT_REPLY, PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_COMMENT_ID, commentId));
    }

    public void viewedInAppFromFull(String conversationId, String messageId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_VIEWED, "message", PLACE_IN_APP, CONTEXT_FROM_FULL).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void viewedInAppFromMessenger(String conversationId, String messageId, String messageStyle) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_VIEWED, "message", "messenger", CONTEXT_FROM_FULL).addMetaData(METADATA_MESSAGE_TYPE, messageStyle).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void viewedInAppFromSnippet(String conversationId, String messageId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_VIEWED, "message", PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void closedInAppFromFull(String conversationId, String messageId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_CLOSED, "message", PLACE_IN_APP, CONTEXT_FROM_FULL).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void receivedPushNotification(String conversationId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, "message", PLACE_PUSH, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION));
    }

    public void receivedPushOnlyNotification(String conversationId) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, "message", PLACE_PUSH, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, "message"));
    }

    public void receivedNotificationFromBadgeWhenMessengerClosed(String badgeValue) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_RECEIVED, OBJECT_BADGE, PLACE_IN_APP, CONTEXT_FROM_LAUNCHER).addMetaData(METADATA_BADGE_VALUE, badgeValue));
    }

    public void viewedArticle(String conversationId, String messageId) {
        this.store.track(this.newMetric(NAME_EDUCATE_METRIC, OWNER_EDUCATE, ACTION_VIEWED, OBJECT_ARTICLE, "messenger", CONTEXT_FROM_CONVERSATION).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void closedArticle(String conversationId, String messageId, boolean pressedDismiss) {
        String context = pressedDismiss ? CONTEXT_FROM_CLOSE_BUTTON : CONTEXT_FROM_ANDROID_BACK_BUTTON;
        this.store.track(this.newMetric(NAME_EDUCATE_METRIC, OWNER_EDUCATE, ACTION_CLOSED, OBJECT_ARTICLE, "messenger", context).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void clickedInput(String conversationId, String input) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_CLICKED, input, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void searchedGifInput(String query) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_SEARCHED, OBJECT_EXPANDED_GIF_INPUT, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_SEARCH_QUERY, query));
    }

    public void expandedInput(String conversationId, String expandedInput) {
        this.store.track(this.newMetric(NAME_MV3_METRIC, "messenger", ACTION_OPENED, OBJECT_EXPANDED_GIF_INPUT, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    private MetricObject newMetric(String name, String owner, String action, String object, String place, String context) {
        return new MetricObject(name, owner, UUID.randomUUID().toString(), this.userIdentity.getIntercomId(), action, object, place, context, this.timeProvider);
    }

    public static enum ReactionLocation {
        CONVERSATION,
        IN_APP,
        LINK;

    }
}

