/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.widget.ImageView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.imageloader.LongTermImageLoader;
import java.io.IOException;

public class WallpaperLoader {
    private final LongTermImageLoader imageLoader;
    private final Provider<AppConfig> appConfigProvider;

    public static WallpaperLoader create(Context context, Provider<AppConfig> appConfigProvider) {
        return new WallpaperLoader(LongTermImageLoader.newInstance(context), appConfigProvider);
    }

    WallpaperLoader(LongTermImageLoader imageLoader, Provider<AppConfig> appConfigProvider) {
        this.imageLoader = imageLoader;
        this.appConfigProvider = appConfigProvider;
    }

    public void loadWallpaperInto(final ImageView imageView, final Listener listener) {
        String wallpaperUrl = this.appConfigProvider.get().getWallpaper();
        if (TextUtils.isEmpty((CharSequence)wallpaperUrl)) {
            return;
        }
        this.imageLoader.loadImage(wallpaperUrl, imageView.getContext(), new LongTermImageLoader.OnImageReadyListener(){

            @Override
            public void onImageReady(Bitmap bitmap) {
                Context context = imageView.getContext();
                if (context == null) {
                    return;
                }
                bitmap.setDensity(160);
                BitmapDrawable tiledWallpaper = new BitmapDrawable(context.getResources(), bitmap);
                tiledWallpaper.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                imageView.setImageDrawable((Drawable)tiledWallpaper);
                listener.onLoadComplete();
            }
        });
    }

    public void close() throws IOException {
        this.imageLoader.close();
    }

    public static interface Listener {
        public void onLoadComplete();
    }
}

