/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.Attachment;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.Blocks;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.Button;
import io.intercom.android.sdk.blocks.ButtonClickListener;
import io.intercom.android.sdk.blocks.Code;
import io.intercom.android.sdk.blocks.ConversationRatingCard;
import io.intercom.android.sdk.blocks.Heading;
import io.intercom.android.sdk.blocks.ImageClickListener;
import io.intercom.android.sdk.blocks.LinkCard;
import io.intercom.android.sdk.blocks.ListBlock;
import io.intercom.android.sdk.blocks.LocalImage;
import io.intercom.android.sdk.blocks.NetworkImage;
import io.intercom.android.sdk.blocks.Paragraph;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.Video;
import io.intercom.android.sdk.blocks.blockInterfaces.AttachmentListBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.ButtonBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.CodeBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.ConversationRatingBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.FacebookBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.HeadingBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.ImageBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.LinkBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.LocalAttachmentBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.LocalImageBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.OrderedListBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.ParagraphBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.SubheadingBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.TwitterBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.UnorderedListBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.VideoBlock;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Part;
import java.util.ArrayList;
import java.util.List;

public class ViewHolderGenerator {
    private final UploadingImageCache uploadingImageCache;
    private final Api api;
    private final Provider<AppConfig> appConfigProvider;
    private final String conversationId;
    private final ImageClickListener imageListener;
    private final ButtonClickListener buttonClickListener;

    public ViewHolderGenerator(UploadingImageCache uploadingImageCache, Api api, Provider<AppConfig> appConfigProvider, String conversationId, ImageClickListener imageListener, ButtonClickListener buttonClickListener) {
        this.uploadingImageCache = uploadingImageCache;
        this.api = api;
        this.appConfigProvider = appConfigProvider;
        this.conversationId = conversationId;
        this.imageListener = imageListener;
        this.buttonClickListener = buttonClickListener;
    }

    public BlocksViewHolder getAdminHolder() {
        return this.generateHolder(R.layout.intercom_blocks_admin_layout, StyleType.ADMIN);
    }

    public BlocksViewHolder getUserHolder() {
        return this.generateHolder(R.layout.intercom_blocks_user_layout, StyleType.USER);
    }

    public BlocksViewHolder getPreviewHolder() {
        return this.generateHolder(R.layout.intercom_blocks_user_layout, StyleType.PREVIEW);
    }

    public BlocksViewHolder getPostHolder() {
        return this.generateHolder(R.layout.intercom_blocks_container_layout, StyleType.POST);
    }

    public BlocksViewHolder getNoteHolder() {
        return this.generateHolder(R.layout.intercom_blocks_note_layout, StyleType.NOTE);
    }

    public BlocksViewHolder getContainerCardHolder() {
        return this.generateHolder(R.layout.intercom_blocks_container_card_layout, StyleType.CONTAINER_CARD);
    }

    public BlocksViewHolder getChatFullHolder() {
        return this.generateHolder(R.layout.intercom_blocks_admin_layout, StyleType.CHAT_FULL);
    }

    public BlocksViewHolder getLinkHolder() {
        return this.generateHolder(R.layout.intercom_blocks_container_layout, StyleType.CHAT_FULL);
    }

    public BlocksViewHolder getConversationRatingHolder() {
        return this.generateHolder(R.layout.intercom_blocks_container_layout, StyleType.CHAT_FULL);
    }

    private BlocksViewHolder generateHolder(@LayoutRes int layoutId, StyleType style2) {
        BlocksViewHolder holder = new BlocksViewHolder();
        Button button = new Button(style2, this.appConfigProvider, this.buttonClickListener);
        Heading heading = new Heading(style2, this.appConfigProvider);
        ListBlock list = new ListBlock(style2, this.appConfigProvider);
        Attachment attachment = new Attachment(style2, this.appConfigProvider);
        holder.setLayout(layoutId);
        holder.setParagraph((ParagraphBlock)new Paragraph(style2, this.appConfigProvider));
        holder.setHeading((HeadingBlock)heading);
        holder.setSubheading((SubheadingBlock)heading);
        holder.setCode((CodeBlock)new Code());
        holder.setUnorderedList((UnorderedListBlock)list);
        holder.setOrderedList((OrderedListBlock)list);
        holder.setImage((ImageBlock)new NetworkImage(style2, this.appConfigProvider, this.uploadingImageCache, this.imageListener));
        holder.setLocalImage((LocalImageBlock)new LocalImage(style2));
        holder.setButton((ButtonBlock)button);
        holder.setAttachmentList((AttachmentListBlock)attachment);
        holder.setLocalAttachment((LocalAttachmentBlock)attachment);
        holder.setTwitterButton((TwitterBlock)button);
        holder.setFacebookButton((FacebookBlock)button);
        holder.setVideo((VideoBlock)new Video(style2, this.api, this.appConfigProvider));
        holder.setLink((LinkBlock)new LinkCard(style2, this.appConfigProvider, this.conversationId));
        holder.setConversationRating((ConversationRatingBlock)new ConversationRatingCard(this.api, this.conversationId, this.appConfigProvider));
        return holder;
    }

    public static LinearLayout createPartsLayout(BlocksViewHolder blocksNoteViewHolder, Part part, Context context) {
        List<Block> blockParts = part.getBlocks();
        if (!part.getAttachments().isEmpty()) {
            ArrayList<BlockAttachment> blockAttachments = new ArrayList<BlockAttachment>();
            for (Attachments attachment : part.getAttachments()) {
                blockAttachments.add(new BlockAttachment.Builder().withName(attachment.getName()).withUrl(attachment.getUrl()).build());
            }
            Block attachmentBlock = new Block.Builder().withType(BlockType.ATTACHMENTLIST.name()).withAttachments(blockAttachments).build();
            blockParts.add(attachmentBlock);
        }
        Blocks blocks = new Blocks(context, LumberMill.getBlocksTwig());
        return blocks.createBlocks(blockParts, blocksNoteViewHolder);
    }

    public static LinearLayout createLayoutFromBlocks(BlocksViewHolder blocksNoteViewHolder, List<Block> blockParts, Context context) {
        Blocks blocks = new Blocks(context, LumberMill.getBlocksTwig());
        return blocks.createBlocks(blockParts, blocksNoteViewHolder);
    }
}

