/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.JavascriptRunner;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.okio.GzipSource;
import io.intercom.okio.Okio;
import io.intercom.okio.Source;
import java.io.InputStream;

class JsCoreWebViewClient
extends WebViewClient {
    private static final String JS_MIME_TYPE = "text/javascript";
    private static final String UTF_8 = "UTF-8";
    private static final String CORE_JS_URL = "http://local-storage/core.js";
    private final JavascriptRunner jsRunner;

    JsCoreWebViewClient(JavascriptRunner jsRunner) {
        this.jsRunner = jsRunner;
    }

    @TargetApi(value=21)
    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        return this.shouldInterceptRequest(view, request.getUrl().toString());
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        if (this.isRequestForFavicon(url)) {
            return new WebResourceResponse(null, null, null);
        }
        if (CORE_JS_URL.equals(url)) {
            return new WebResourceResponse(JS_MIME_TYPE, UTF_8, this.getCoreJsStream(view.getContext()));
        }
        return null;
    }

    @Nullable
    private InputStream getCoreJsStream(Context context) {
        try {
            InputStream resStream = context.getResources().openRawResource(R.raw.intercom_core_f507adc3);
            return Okio.buffer((Source)new GzipSource(Okio.source((InputStream)resStream))).inputStream();
        }
        catch (Resources.NotFoundException e) {
            LumberMill.getLogger().internal("Couldn't find JS: " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            LumberMill.getLogger().internal("Couldn't load JS: " + e.getMessage());
            return null;
        }
    }

    public void onPageFinished(WebView view, String url) {
        this.jsRunner.runPendingScripts();
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        if (this.isRequestForFavicon(failingUrl)) {
            return;
        }
        this.jsRunner.clearPendingScripts();
    }

    @TargetApi(value=23)
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        this.onReceivedError(view, error.getErrorCode(), error.getDescription().toString(), request.getUrl().toString());
    }

    private boolean isRequestForFavicon(String url) {
        return url.contains("/favicon.ico");
    }
}

