/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Activity;
import android.app.Application;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.LifecycleTracker;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.SimpleActivityLifecycleCallbacks;
import java.util.HashSet;
import java.util.Set;

class LateInitializationPreparer
extends SimpleActivityLifecycleCallbacks {
    private final Twig twig = LumberMill.getLogger();
    private final Set<Integer> startedActivities = new HashSet<Integer>();
    @Nullable
    private Activity lastResumedActivity;
    private boolean hasPaused;

    LateInitializationPreparer() {
    }

    void handlePastLifecycleEvents(Application application, Injector injector) {
        Activity lastResumedActivity = this.lastResumedActivity;
        boolean hasPaused = this.hasPaused;
        Set<Integer> startedActivities = this.startedActivities;
        this.unregister(application);
        if (lastResumedActivity != null) {
            this.twig.i("Handling lifecycle events for " + lastResumedActivity + " during late initialisation", new Object[0]);
            LifecycleTracker lifecycleTracker = injector.getLifecycleTracker();
            lifecycleTracker.onActivityStarted(lastResumedActivity);
            lifecycleTracker.onActivityResumed(lastResumedActivity);
            if (hasPaused) {
                lifecycleTracker.onActivityPaused(lastResumedActivity);
            }
        }
        if (!startedActivities.isEmpty()) {
            injector.getLifecycleTracker().registerActivities(startedActivities);
            this.twig.i("Observed Activities with hashcodes " + startedActivities + " during late initialization", new Object[0]);
        }
    }

    void register(Application application) {
        this.twig.i("Registering for later initialization", new Object[0]);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    void unregister(Application application) {
        this.twig.i("Unregistering for later initialization", new Object[0]);
        application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.lastResumedActivity = null;
        this.hasPaused = false;
    }

    @Override
    public void onActivityStarted(Activity activity) {
        this.startedActivities.add(System.identityHashCode(activity));
    }

    @Override
    public void onActivityResumed(Activity activity) {
        this.startedActivities.add(System.identityHashCode(activity));
        this.lastResumedActivity = activity;
        this.hasPaused = false;
    }

    @Override
    public void onActivityPaused(Activity activity) {
        this.startedActivities.add(System.identityHashCode(activity));
        this.hasPaused = true;
    }

    @Override
    public void onActivityStopped(Activity activity) {
        this.startedActivities.remove(System.identityHashCode(activity));
        if (activity == this.lastResumedActivity) {
            this.lastResumedActivity = null;
        }
    }

    @VisibleForTesting
    boolean hasPaused() {
        return this.hasPaused;
    }

    @VisibleForTesting
    @Nullable
    Activity lastResumedActivity() {
        return this.lastResumedActivity;
    }

    @VisibleForTesting
    Set<Integer> startedActivities() {
        return this.startedActivities;
    }
}

