/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.View;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.LinkOpener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class IntercomLinkView
extends AppCompatTextView {
    private static final int INTERCOM_LINK_ANIMATION_TIME_MS = 100;
    private final int conversationBottomPaddingPx;
    private final int[] lastChildPosition = new int[2];
    private final int[] intercomLinkPosition = new int[2];
    private int lastBottomPosition = 0;
    private final Twig twig = LumberMill.getLogger();

    public IntercomLinkView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.conversationBottomPaddingPx = ScreenUtils.dpToPx((float)8.0f, (Context)this.getContext());
    }

    public void followIntercomLink(Provider<AppConfig> appConfigProvider, Part firstPart, Api api) {
        LinkOpener.handleUrl(this.createIntercomLinkUrl(appConfigProvider, firstPart), this.getContext(), api);
    }

    String createIntercomLinkUrl(Provider<AppConfig> appConfigProvider, Part firstPart) {
        return "http://www.intercom.io/intercom-link?company=" + this.getCompanyForUrl(appConfigProvider.get().getName()) + "&product=" + IntercomLinkView.getProductForUrl(firstPart) + "&utm_source=android-sdk&utm_campaign=intercom-link&utm_content=we-run-on-intercom&utm_medium=messenger";
    }

    private String getCompanyForUrl(String companyName) {
        try {
            return URLEncoder.encode(companyName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.twig.i("Could not url encode the app name", new Object[0]);
            return "";
        }
    }

    private static String getProductForUrl(Part firstPart) {
        if (Part.NULL == firstPart || firstPart.isUser()) {
            return "resolve";
        }
        if (firstPart.isLinkCard() && "educate.article".equals(firstPart.getLinkBlock().getLinkType())) {
            return "educate";
        }
        return "engage";
    }

    public void hideIfIntersectedOrShow(View lastChild) {
        lastChild.getLocationOnScreen(this.lastChildPosition);
        int bottomOfLastElement = this.lastChildPosition[1] + lastChild.getHeight() + this.conversationBottomPaddingPx;
        this.getLocationOnScreen(this.intercomLinkPosition);
        if (bottomOfLastElement >= this.intercomLinkPosition[1] && this.lastBottomPosition < this.intercomLinkPosition[1]) {
            this.hide();
        } else if (bottomOfLastElement < this.intercomLinkPosition[1] && this.lastBottomPosition >= this.intercomLinkPosition[1]) {
            this.show();
        }
        this.lastBottomPosition = bottomOfLastElement;
    }

    public void show() {
        this.animate().alpha(1.0f).setDuration(100L);
    }

    public void hide() {
        this.animate().alpha(0.0f).setDuration(100L);
    }
}

