/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities.connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.utilities.connectivity.NetworkState;

class ConnectivityBroadcastReceiver
extends BroadcastReceiver {
    private final ConnectivityUpdateListener connectivityUpdateListener;

    ConnectivityBroadcastReceiver(ConnectivityUpdateListener connectivityUpdateListener) {
        this.connectivityUpdateListener = connectivityUpdateListener;
    }

    public void onReceive(@Nullable Context context, @Nullable Intent intent) {
        if (intent == null || !"android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            return;
        }
        NetworkState state = intent.getBooleanExtra("noConnectivity", false) ? NetworkState.NOT_CONNECTED : NetworkState.CONNECTED;
        this.connectivityUpdateListener.onUpdate(state);
    }

    static interface ConnectivityUpdateListener {
        public void onUpdate(NetworkState var1);
    }
}

