/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.profile;

import android.support.annotation.DimenRes;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.profile.TeamProfilePresenter;
import io.intercom.android.sdk.profile.TeammateProfilePresenter;
import java.util.List;

public class ProfilePresenter {
    final AppBarLayout appBarLayout;
    private final View toolbar;
    private String conversationId = "";
    private final CoordinatorLayout coordinatorLayout;
    private final ViewGroup titleLayoutCoordinator;
    ProfileState currentState = ProfileState.IDLE;
    boolean isAnimating = false;
    private boolean didShowUnknown = false;
    private boolean wasClicked = false;
    private boolean autoOpened = false;
    private final TeammateProfilePresenter teammateProfilePresenter;
    private final TeamProfilePresenter teamProfilePresenter;
    private final MetricTracker metricTracker;
    private final Provider<AppConfig> appConfigProvider;
    private final AppBarLayout.OnOffsetChangedListener offsetListener = new AppBarLayout.OnOffsetChangedListener(){

        public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
            if (verticalOffset == 0) {
                if (ProfilePresenter.this.currentState != ProfileState.EXPANDED) {
                    ProfilePresenter.this.trackOpenMetric();
                    InputMethodManager inputMethodManager = (InputMethodManager)appBarLayout.getContext().getSystemService("input_method");
                    inputMethodManager.hideSoftInputFromWindow(appBarLayout.getWindowToken(), 0);
                }
                ProfilePresenter.this.isAnimating = false;
                ProfilePresenter.this.currentState = ProfileState.EXPANDED;
            } else if (Math.abs(verticalOffset) >= appBarLayout.getTotalScrollRange()) {
                ProfilePresenter.this.isAnimating = false;
                ProfilePresenter.this.currentState = ProfileState.COLLAPSED;
            } else {
                ProfilePresenter.this.currentState = ProfileState.IDLE;
            }
        }
    };

    public ProfilePresenter(CoordinatorLayout rootView, MetricTracker metricTracker, Provider<AppConfig> appConfigProvider) {
        this.appConfigProvider = appConfigProvider;
        this.metricTracker = metricTracker;
        this.coordinatorLayout = (CoordinatorLayout)rootView.findViewById(R.id.conversation_coordinator_layout);
        this.appBarLayout = (AppBarLayout)rootView.findViewById(R.id.app_bar_layout);
        this.toolbar = rootView.findViewById(R.id.profile_toolbar);
        this.titleLayoutCoordinator = (FrameLayout)rootView.findViewById(R.id.profile_toolbar_coordinator);
        int baseColor = appConfigProvider.get().getBaseColor();
        this.teammateProfilePresenter = new TeammateProfilePresenter(rootView, baseColor, this, appConfigProvider);
        this.teamProfilePresenter = new TeamProfilePresenter(rootView, baseColor, this, appConfigProvider);
    }

    public void setUnknownPresence() {
        this.didShowUnknown = true;
        this.teammateProfilePresenter.getRootLayout().setAlpha(0.0f);
        this.teamProfilePresenter.getRootLayout().setAlpha(0.0f);
        this.toolbar.setBackgroundColor(this.appConfigProvider.get().getBaseColor());
        this.appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.teamProfilePresenter.getToolbarBehavior());
        this.appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.teammateProfilePresenter.getToolbarBehavior());
    }

    public void setTeamPresence(TeamPresence teamPresence, int maxWidth) {
        this.teamProfilePresenter.setTeamCollapsingTitle(this.appConfigProvider.get().getName());
        if (teamPresence.isEmpty()) {
            this.teammateProfilePresenter.setTeammateSubtitle(null);
        } else {
            this.toolbar.setBackgroundColor(0);
            this.appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.teammateProfilePresenter.getToolbarBehavior());
            this.teamProfilePresenter.setPresence(teamPresence, maxWidth, this.appBarLayout, (View)this.teammateProfilePresenter.getRootLayout(), (View)this.titleLayoutCoordinator);
        }
    }

    public void setTeammatePresence(LastParticipatingAdmin lastParticipant, List<Participant> groupParticipants, CharSequence lastActiveTime, int maxWidth) {
        this.toolbar.setBackgroundColor(0);
        this.appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.teamProfilePresenter.getToolbarBehavior());
        this.teammateProfilePresenter.setPresence(lastParticipant, groupParticipants, lastActiveTime, maxWidth, this.appBarLayout, this.currentState, (View)this.teamProfilePresenter.getRootLayout(), (View)this.titleLayoutCoordinator);
    }

    void applyOffsetChangedListener(final AppBarLayout.OnOffsetChangedListener behavior) {
        this.appBarLayout.addOnOffsetChangedListener(behavior);
        this.appBarLayout.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                ProfilePresenter.this.appBarLayout.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                behavior.onOffsetChanged(ProfilePresenter.this.appBarLayout, 0);
                return false;
            }
        });
    }

    public void startOffsetListener() {
        this.appBarLayout.addOnOffsetChangedListener(this.offsetListener);
    }

    public void addListener(AppBarLayout.OnOffsetChangedListener listener) {
        this.appBarLayout.addOnOffsetChangedListener(listener);
    }

    public boolean isExpanded() {
        return this.currentState == ProfileState.EXPANDED;
    }

    void trackOpenMetric() {
        ProfileType profileType;
        ProfileType profileType2 = profileType = this.teamProfilePresenter.getRootLayout().getAlpha() == 0.0f ? ProfileType.TEAMMATE : ProfileType.TEAM;
        if (this.wasClicked) {
            this.metricTracker.profileClickedOpen(this.conversationId, profileType);
        } else if (this.autoOpened) {
            this.metricTracker.profileAutoOpen(this.conversationId, profileType);
        } else {
            this.metricTracker.profileScrolledOpen(this.conversationId, profileType);
        }
        this.wasClicked = false;
        this.autoOpened = false;
    }

    public void profileAutoOpened() {
        this.autoOpened = true;
        this.flingProfileOpen();
    }

    public void profileClicked() {
        this.wasClicked = true;
        this.flingProfileOpen();
    }

    private void flingProfileOpen() {
        this.flingProfile(R.dimen.intercom_open_velocity);
    }

    public void flingProfileClosed() {
        this.flingProfile(R.dimen.intercom_close_velocity);
    }

    private void flingProfile(@DimenRes int yVelocityRes) {
        if (this.isAnimating) {
            return;
        }
        CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)this.appBarLayout.getLayoutParams();
        AppBarLayout.Behavior behavior = (AppBarLayout.Behavior)params.getBehavior();
        if (behavior != null) {
            int velocity = this.appBarLayout.getResources().getDimensionPixelSize(yVelocityRes);
            behavior.onNestedFling(this.coordinatorLayout, this.appBarLayout, null, 0.0f, (float)velocity, false);
        }
        this.isAnimating = true;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    boolean isDidShowUnknown() {
        return this.didShowUnknown;
    }

    void setDidShowUnknown(boolean didShowUnknown) {
        this.didShowUnknown = didShowUnknown;
    }

    public void onStop() {
        this.teammateProfilePresenter.stopUpdatingTime();
    }

    static enum ProfileState {
        COLLAPSED,
        EXPANDED,
        IDLE;

    }

    public static enum ProfileType {
        TEAMMATE,
        TEAM;

    }
}

