/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import io.intercom.android.sdk.R;

public class InboxEmptyRowsView
extends View {
    private static final int NUMBER_OF_ROWS = 3;
    private static final int ITEM_HEIGHT = 68;
    private static final int PADDING_X = 16;
    private static final int CIRCLE_RADIUS = 24;
    private static final int CIRCLE_TOP_PADDING = 20;
    private static final int LINE_LEFT_X = 80;
    private static final int UPPER_LINE_TOP_Y = 28;
    private static final int UPPER_LINE_WIDTH = 116;
    private static final int UPPER_LINE_BOTTOM_Y = 40;
    private static final int LINE_CORNER_RADIUS = 4;
    private static final int LOWER_LINE_TOP_Y = 52;
    private static final int LOWER_LINE_BOTTOM_Y = 64;
    private final Paint paint = new Paint();
    private final RectF rect = new RectF();
    private final float density;

    public InboxEmptyRowsView(Context context) {
        this(context, null);
    }

    public InboxEmptyRowsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_error_state_empty_avatar));
        this.density = this.getResources().getDisplayMetrics().density;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < 3; ++i) {
            int currentY = i * 68;
            canvas.drawCircle(this.dpToPx(40), this.dpToPx(44 + currentY), this.dpToPx(24), this.paint);
            this.rect.set(this.dpToPx(80), this.dpToPx(28 + currentY), this.dpToPx(196), this.dpToPx(40 + currentY));
            canvas.drawRoundRect(this.rect, this.dpToPx(4), this.dpToPx(4), this.paint);
            this.rect.set(this.dpToPx(80), this.dpToPx(52 + currentY), (float)this.getWidth() - this.dpToPx(16), this.dpToPx(64 + currentY));
            canvas.drawRoundRect(this.rect, this.dpToPx(4), this.dpToPx(4), this.paint);
        }
    }

    private float dpToPx(int x) {
        return (float)x * this.density;
    }
}

