/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import io.intercom.com.bumptech.glide.util.LruCache;
import io.intercom.com.bumptech.glide.util.Util;
import java.util.Queue;

public class ModelCache<A, B> {
    private static final int DEFAULT_SIZE = 250;
    private final LruCache<ModelKey<A>, B> cache;

    public ModelCache() {
        this(250);
    }

    public ModelCache(int size) {
        this.cache = new LruCache<ModelKey<A>, B>(size){

            @Override
            protected void onItemEvicted(ModelKey<A> key, B item) {
                key.release();
            }
        };
    }

    public B get(A model, int width, int height) {
        ModelKey<A> key = ModelKey.get(model, width, height);
        B result = this.cache.get(key);
        key.release();
        return result;
    }

    public void put(A model, int width, int height, B value) {
        ModelKey<A> key = ModelKey.get(model, width, height);
        this.cache.put(key, value);
    }

    static final class ModelKey<A> {
        private static final Queue<ModelKey<?>> KEY_QUEUE = Util.createQueue(0);
        private int height;
        private int width;
        private A model;

        static <A> ModelKey<A> get(A model, int width, int height) {
            ModelKey<Object> modelKey = KEY_QUEUE.poll();
            if (modelKey == null) {
                modelKey = new ModelKey<A>();
            }
            super.init(model, width, height);
            return modelKey;
        }

        private ModelKey() {
        }

        private void init(A model, int width, int height) {
            this.model = model;
            this.width = width;
            this.height = height;
        }

        public void release() {
            KEY_QUEUE.offer(this);
        }

        public boolean equals(Object o) {
            if (o instanceof ModelKey) {
                ModelKey other = (ModelKey)o;
                return this.width == other.width && this.height == other.height && this.model.equals(other.model);
            }
            return false;
        }

        public int hashCode() {
            int result = this.height;
            result = 31 * result + this.width;
            result = 31 * result + this.model.hashCode();
            return result;
        }
    }
}

