/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.view.ContextThemeWrapper;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import java.util.Locale;

public class ContextLocaliser {
    private static final String SIMPLIFIED_CHINESE_ISO_15924 = "hans";
    private static final String SIMPLIFIED_CHINESE_COUNTRY = "CN";
    private static final String TRADITIONAL_CHINESE_ISO_15924 = "hant";
    private static final String TRADITIONAL_CHINESE_COUNTRY = "TW";
    private static final String FORMAL_TAG = "form";
    private static final String FAKE_FORMAL_COUNTRY = "FO";
    private static final Twig twig = LumberMill.getLogger();
    private final Provider<AppConfig> appConfigProvider;

    public static ContextLocaliser create() {
        return new ContextLocaliser(Injector.get().getAppConfigProvider());
    }

    public ContextLocaliser(Provider<AppConfig> appIdentity) {
        this.appConfigProvider = appIdentity;
    }

    public Context createLocalisedContext(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            Configuration localisedConfiguration = new Configuration(context.getResources().getConfiguration());
            Locale newLocale = ContextLocaliser.convertToLocale(this.appConfigProvider.get().getLocale());
            localisedConfiguration.setLocale(newLocale);
            return context.createConfigurationContext(localisedConfiguration);
        }
        twig.d("Localisation outside the Messenger is unsupported on Android 4.0 and 4.1, text may be localised incorrectly", new Object[0]);
        return context;
    }

    static Locale convertToLocale(String locale) {
        if (locale.length() <= 2) {
            return new Locale(locale);
        }
        String language = locale.substring(0, 2);
        String country = locale.substring(3);
        if (SIMPLIFIED_CHINESE_ISO_15924.equalsIgnoreCase(country)) {
            country = SIMPLIFIED_CHINESE_COUNTRY;
        } else if (TRADITIONAL_CHINESE_ISO_15924.equalsIgnoreCase(country)) {
            country = TRADITIONAL_CHINESE_COUNTRY;
        } else if (FORMAL_TAG.equalsIgnoreCase(country)) {
            country = FAKE_FORMAL_COUNTRY;
        }
        return new Locale(language, country);
    }

    public void applyOverrideConfiguration(ContextThemeWrapper wrapper, Context baseContext) {
        if (Build.VERSION.SDK_INT >= 17) {
            Configuration overrideConfiguration = new Configuration(baseContext.getResources().getConfiguration());
            Locale newLocale = ContextLocaliser.convertToLocale(this.appConfigProvider.get().getLocale());
            overrideConfiguration.setLocale(newLocale);
            wrapper.applyOverrideConfiguration(overrideConfiguration);
        }
    }
}

