/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.utilities.NullSafety;

public class Reaction
implements Parcelable {
    private final int index;
    private final String imageUrl;
    public static final Parcelable.Creator<Reaction> CREATOR = new Parcelable.Creator<Reaction>(){

        public Reaction createFromParcel(Parcel in) {
            return new Reaction(in);
        }

        public Reaction[] newArray(int size) {
            return new Reaction[size];
        }
    };

    public Reaction() {
        this(new Builder());
    }

    Reaction(Builder builder) {
        this.index = builder.index;
        this.imageUrl = NullSafety.valueOrEmpty(builder.image_url);
    }

    public int getIndex() {
        return this.index;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reaction reaction = (Reaction)o;
        if (this.index != reaction.index) {
            return false;
        }
        return this.imageUrl.equals(reaction.imageUrl);
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + this.imageUrl.hashCode();
        return result;
    }

    Reaction(Parcel in) {
        this.index = in.readInt();
        this.imageUrl = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.index);
        dest.writeString(this.imageUrl);
    }

    public static final class Builder {
        int index;
        String image_url;

        public Reaction build() {
            return new Reaction(this);
        }
    }
}

