/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.util;

import android.text.TextUtils;
import android.util.Log;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ContentLengthInputStream
extends FilterInputStream {
    private static final String TAG = "ContentLengthStream";
    private static final int UNKNOWN = -1;
    private final long contentLength;
    private int readSoFar;

    public static InputStream obtain(InputStream other, String contentLengthHeader) {
        return ContentLengthInputStream.obtain(other, ContentLengthInputStream.parseContentLength(contentLengthHeader));
    }

    public static InputStream obtain(InputStream other, long contentLength) {
        return new ContentLengthInputStream(other, contentLength);
    }

    private static int parseContentLength(String contentLengthHeader) {
        int result;
        block3: {
            result = -1;
            if (!TextUtils.isEmpty((CharSequence)contentLengthHeader)) {
                try {
                    result = Integer.parseInt(contentLengthHeader);
                }
                catch (NumberFormatException e) {
                    if (!Log.isLoggable((String)TAG, (int)3)) break block3;
                    Log.d((String)TAG, (String)("failed to parse content length header: " + contentLengthHeader), (Throwable)e);
                }
            }
        }
        return result;
    }

    ContentLengthInputStream(InputStream in, long contentLength) {
        super(in);
        this.contentLength = contentLength;
    }

    @Override
    public synchronized int available() throws IOException {
        return (int)Math.max(this.contentLength - (long)this.readSoFar, (long)this.in.available());
    }

    @Override
    public synchronized int read() throws IOException {
        return this.checkReadSoFarOrThrow(super.read());
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public synchronized int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        return this.checkReadSoFarOrThrow(super.read(buffer, byteOffset, byteCount));
    }

    private int checkReadSoFarOrThrow(int read) throws IOException {
        if (read >= 0) {
            this.readSoFar += read;
        } else if (this.contentLength - (long)this.readSoFar > 0L) {
            throw new IOException("Failed to read all expected data, expected: " + this.contentLength + ", but read: " + this.readSoFar);
        }
        return read;
    }
}

