/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.gif;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.gifdecoder.GifDecoder;
import io.intercom.com.bumptech.glide.gifdecoder.GifHeader;
import io.intercom.com.bumptech.glide.gifdecoder.GifHeaderParser;
import io.intercom.com.bumptech.glide.load.ResourceDecoder;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.resource.UnitTransformation;
import io.intercom.com.bumptech.glide.load.resource.gif.GifBitmapProvider;
import io.intercom.com.bumptech.glide.load.resource.gif.GifDrawable;
import io.intercom.com.bumptech.glide.load.resource.gif.GifDrawableResource;
import io.intercom.com.bumptech.glide.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;

public class GifResourceDecoder
implements ResourceDecoder<InputStream, GifDrawable> {
    private static final String TAG = "GifResourceDecoder";
    private static final GifHeaderParserPool PARSER_POOL = new GifHeaderParserPool();
    private static final GifDecoderPool DECODER_POOL = new GifDecoderPool();
    private final Context context;
    private final GifHeaderParserPool parserPool;
    private final BitmapPool bitmapPool;
    private final GifDecoderPool decoderPool;
    private final GifBitmapProvider provider;

    public GifResourceDecoder(Context context) {
        this(context, Glide.get(context).getBitmapPool());
    }

    public GifResourceDecoder(Context context, BitmapPool bitmapPool) {
        this(context, bitmapPool, PARSER_POOL, DECODER_POOL);
    }

    GifResourceDecoder(Context context, BitmapPool bitmapPool, GifHeaderParserPool parserPool, GifDecoderPool decoderPool) {
        this.context = context;
        this.bitmapPool = bitmapPool;
        this.decoderPool = decoderPool;
        this.provider = new GifBitmapProvider(bitmapPool);
        this.parserPool = parserPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GifDrawableResource decode(InputStream source, int width, int height) {
        byte[] data = GifResourceDecoder.inputStreamToBytes(source);
        GifHeaderParser parser = this.parserPool.obtain(data);
        GifDecoder decoder = this.decoderPool.obtain(this.provider);
        try {
            GifDrawableResource gifDrawableResource = this.decode(data, width, height, parser, decoder);
            return gifDrawableResource;
        }
        finally {
            this.parserPool.release(parser);
            this.decoderPool.release(decoder);
        }
    }

    private GifDrawableResource decode(byte[] data, int width, int height, GifHeaderParser parser, GifDecoder decoder) {
        GifHeader header = parser.parseHeader();
        if (header.getNumFrames() <= 0 || header.getStatus() != 0) {
            return null;
        }
        Bitmap firstFrame = this.decodeFirstFrame(decoder, header, data);
        if (firstFrame == null) {
            return null;
        }
        UnitTransformation<Bitmap> unitTransformation = UnitTransformation.get();
        GifDrawable gifDrawable = new GifDrawable(this.context, this.provider, this.bitmapPool, unitTransformation, width, height, header, data, firstFrame);
        return new GifDrawableResource(gifDrawable);
    }

    private Bitmap decodeFirstFrame(GifDecoder decoder, GifHeader header, byte[] data) {
        decoder.setData(header, data);
        decoder.advance();
        return decoder.getNextFrame();
    }

    @Override
    public String getId() {
        return "";
    }

    private static byte[] inputStreamToBytes(InputStream is) {
        int bufferSize = 16384;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(16384);
        try {
            int nRead;
            byte[] data = new byte[16384];
            while ((nRead = is.read(data)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)e);
        }
        return buffer.toByteArray();
    }

    static class GifHeaderParserPool {
        private final Queue<GifHeaderParser> pool = Util.createQueue(0);

        GifHeaderParserPool() {
        }

        public synchronized GifHeaderParser obtain(byte[] data) {
            GifHeaderParser result = this.pool.poll();
            if (result == null) {
                result = new GifHeaderParser();
            }
            return result.setData(data);
        }

        public synchronized void release(GifHeaderParser parser) {
            parser.clear();
            this.pool.offer(parser);
        }
    }

    static class GifDecoderPool {
        private final Queue<GifDecoder> pool = Util.createQueue(0);

        GifDecoderPool() {
        }

        public synchronized GifDecoder obtain(GifDecoder.BitmapProvider bitmapProvider) {
            GifDecoder result = this.pool.poll();
            if (result == null) {
                result = new GifDecoder(bitmapProvider);
            }
            return result;
        }

        public synchronized void release(GifDecoder decoder) {
            decoder.clear();
            this.pool.offer(decoder);
        }
    }
}

