/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.models;

import android.os.Parcel;
import android.os.Parcelable;

public class Channel
implements Parcelable {
    private final String name;
    private final String label;
    private final String value;
    public static final Parcelable.Creator<Channel> CREATOR = new Parcelable.Creator<Channel>(){

        public Channel createFromParcel(Parcel source) {
            return new Channel(source);
        }

        public Channel[] newArray(int size) {
            return new Channel[size];
        }
    };

    Channel() {
        this(new Builder());
    }

    private Channel(Builder builder) {
        this.name = builder.name == null ? "" : builder.name;
        this.label = builder.label == null ? "" : builder.label;
        this.value = builder.value == null ? "" : builder.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "Channel{name='" + this.name + '\'' + ", label='" + this.label + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel channel = (Channel)o;
        if (this.name != null ? !this.name.equals(channel.name) : channel.name != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(channel.label) : channel.label != null) {
            return false;
        }
        return this.value != null ? this.value.equals(channel.value) : channel.value == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeString(this.label);
        dest.writeString(this.value);
    }

    protected Channel(Parcel in) {
        this.name = in.readString();
        this.label = in.readString();
        this.value = in.readString();
    }

    public static final class Builder {
        String name;
        String label;
        String value;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Channel build() {
            return new Channel(this);
        }
    }
}

