/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.support.annotation.Nullable;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationsResponse;
import io.intercom.android.sdk.models.GifResponse;
import io.intercom.android.sdk.models.LinkResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReadResponse;
import io.intercom.android.sdk.models.UpdateUserResponse;
import io.intercom.android.sdk.models.Upload;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.retrofit2.Call;
import io.intercom.retrofit2.http.Body;
import io.intercom.retrofit2.http.POST;
import io.intercom.retrofit2.http.PUT;
import io.intercom.retrofit2.http.Path;
import io.intercom.retrofit2.http.Query;
import java.util.Map;

interface MessengerApi {
    @POST(value="conversations")
    public Call<Conversation.Builder> startNewConversation(@Body Map<String, Object> var1);

    @POST(value="conversations/{conversationId}/react")
    public Call<Void> reactToConversation(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="conversations/{conversationId}/reply")
    public Call<Part.Builder> replyToConversation(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="conversations/{conversationId}/read")
    public Call<ReadResponse.Builder> markAsRead(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="conversations/dismiss")
    public Call<Void> markAsDismissed(@Body Map<String, Object> var1);

    @POST(value="conversations/inbox")
    public Call<ConversationsResponse.Builder> getConversations(@Body Map<String, Object> var1);

    @POST(value="conversations/unread")
    public Call<UsersResponse.Builder> getUnreadConversations(@Body Map<String, Object> var1);

    @POST(value="conversations/{conversationId}")
    public Call<Conversation.Builder> getConversation(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="users")
    public Call<UpdateUserResponse.Builder> updateUser(@Body Map<String, Object> var1);

    @POST(value="events")
    public Call<UsersResponse.Builder> logEvent(@Body Map<String, Object> var1);

    @POST(value="uploads")
    public Call<Upload.Builder> uploadFile(@Body Map<String, Object> var1);

    @POST(value="device_tokens")
    public Call<Void> setDeviceToken(@Body Map<String, Object> var1);

    @PUT(value="device_tokens")
    public Call<Void> deleteDeviceToken(@Body Map<String, Object> var1);

    @POST(value="metrics")
    public Call<Void> sendMetrics(@Body Map<String, Object> var1);

    @POST(value="articles/{articleId}")
    public Call<LinkResponse.Builder> getLink(@Path(value="articleId") String var1, @Body Map<String, Object> var2);

    @POST(value="articles/{articleId}/react")
    public Call<Void> reactToLink(@Path(value="articleId") String var1, @Body Map<String, Object> var2);

    @POST(value="gifs")
    public Call<GifResponse> getGifs(@Query(value="query") @Nullable String var1);
}

