/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import io.intercom.com.bumptech.glide.BitmapTypeRequest;
import io.intercom.com.bumptech.glide.DownloadOptions;
import io.intercom.com.bumptech.glide.DrawableRequestBuilder;
import io.intercom.com.bumptech.glide.GenericTranscodeRequest;
import io.intercom.com.bumptech.glide.GifTypeRequest;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.load.model.ImageVideoModelLoader;
import io.intercom.com.bumptech.glide.load.model.ImageVideoWrapper;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.load.resource.gifbitmap.GifBitmapWrapper;
import io.intercom.com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import io.intercom.com.bumptech.glide.manager.Lifecycle;
import io.intercom.com.bumptech.glide.manager.RequestTracker;
import io.intercom.com.bumptech.glide.provider.DataLoadProvider;
import io.intercom.com.bumptech.glide.provider.FixedLoadProvider;
import io.intercom.com.bumptech.glide.request.FutureTarget;
import io.intercom.com.bumptech.glide.request.target.Target;
import java.io.File;
import java.io.InputStream;

public class DrawableTypeRequest<ModelType>
extends DrawableRequestBuilder<ModelType>
implements DownloadOptions {
    private final ModelLoader<ModelType, InputStream> streamModelLoader;
    private final ModelLoader<ModelType, ParcelFileDescriptor> fileDescriptorModelLoader;
    private final RequestManager.OptionsApplier optionsApplier;

    private static <A, Z, R> FixedLoadProvider<A, ImageVideoWrapper, Z, R> buildProvider(Glide glide, ModelLoader<A, InputStream> streamModelLoader, ModelLoader<A, ParcelFileDescriptor> fileDescriptorModelLoader, Class<Z> resourceClass, Class<R> transcodedClass, ResourceTranscoder<Z, R> transcoder) {
        if (streamModelLoader == null && fileDescriptorModelLoader == null) {
            return null;
        }
        if (transcoder == null) {
            transcoder = glide.buildTranscoder(resourceClass, transcodedClass);
        }
        DataLoadProvider<ImageVideoWrapper, Z> dataLoadProvider = glide.buildDataProvider(ImageVideoWrapper.class, resourceClass);
        ImageVideoModelLoader<A> modelLoader = new ImageVideoModelLoader<A>(streamModelLoader, fileDescriptorModelLoader);
        return new FixedLoadProvider(modelLoader, transcoder, dataLoadProvider);
    }

    DrawableTypeRequest(Class<ModelType> modelClass, ModelLoader<ModelType, InputStream> streamModelLoader, ModelLoader<ModelType, ParcelFileDescriptor> fileDescriptorModelLoader, Context context, Glide glide, RequestTracker requestTracker, Lifecycle lifecycle, RequestManager.OptionsApplier optionsApplier) {
        super(context, modelClass, DrawableTypeRequest.buildProvider(glide, streamModelLoader, fileDescriptorModelLoader, GifBitmapWrapper.class, GlideDrawable.class, null), glide, requestTracker, lifecycle);
        this.streamModelLoader = streamModelLoader;
        this.fileDescriptorModelLoader = fileDescriptorModelLoader;
        this.optionsApplier = optionsApplier;
    }

    public BitmapTypeRequest<ModelType> asBitmap() {
        return this.optionsApplier.apply(new BitmapTypeRequest<ModelType>(this, this.streamModelLoader, this.fileDescriptorModelLoader, this.optionsApplier));
    }

    public GifTypeRequest<ModelType> asGif() {
        return this.optionsApplier.apply(new GifTypeRequest<ModelType>(this, this.streamModelLoader, this.optionsApplier));
    }

    @Override
    public <Y extends Target<File>> Y downloadOnly(Y target) {
        return this.getDownloadOnlyRequest().downloadOnly(target);
    }

    @Override
    public FutureTarget<File> downloadOnly(int width, int height) {
        return this.getDownloadOnlyRequest().downloadOnly(width, height);
    }

    private GenericTranscodeRequest<ModelType, InputStream, File> getDownloadOnlyRequest() {
        return this.optionsApplier.apply(new GenericTranscodeRequest<ModelType, InputStream, File>(File.class, this, this.streamModelLoader, InputStream.class, File.class, this.optionsApplier));
    }
}

