/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.intercom.android.sdk.R;
import java.util.concurrent.TimeUnit;

public class AdminIsTypingView
extends LinearLayout {
    private static final int IS_TYPING_DURATION_SECONDS = 10;
    private static final int ANIMATION_DELAY_MILLIS = 100;
    final ImageView[] dots = new ImageView[3];
    final AnimatorSet[] dotsAnimations = new AnimatorSet[3];
    boolean animating = false;
    @Nullable
    private Listener listener;
    final Runnable animateDots = new Runnable(){

        @Override
        public void run() {
            for (int i = 0; i < AdminIsTypingView.this.dots.length; ++i) {
                AdminIsTypingView.this.dotsAnimations[i].setTarget((Object)AdminIsTypingView.this.dots[i]);
                AdminIsTypingView.this.dotsAnimations[i].start();
            }
            AdminIsTypingView.this.postDelayed(AdminIsTypingView.this.animateDots, TimeUnit.SECONDS.toMillis(1L));
        }
    };
    final Runnable endAnimation = new Runnable(){

        @Override
        public void run() {
            AdminIsTypingView.this.animating = false;
            AdminIsTypingView.this.removeCallbacks(AdminIsTypingView.this.animateDots);
            AdminIsTypingView.this.removeCallbacks(AdminIsTypingView.this.endAnimation);
            if (AdminIsTypingView.this.listener != null) {
                AdminIsTypingView.this.listener.onAdminTypingAnimationEnded(AdminIsTypingView.this);
            }
            for (AnimatorSet set : AdminIsTypingView.this.dotsAnimations) {
                set.cancel();
            }
        }
    };

    public AdminIsTypingView(Context context) {
        this(context, null);
    }

    public AdminIsTypingView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        AdminIsTypingView.inflate((Context)this.getContext(), (int)R.layout.intercom_admin_is_typing, (ViewGroup)this);
        this.dots[0] = (ImageView)this.findViewById(R.id.dot1);
        this.dots[1] = (ImageView)this.findViewById(R.id.dot2);
        this.dots[2] = (ImageView)this.findViewById(R.id.dot3);
        for (int i = 0; i < this.dotsAnimations.length; ++i) {
            this.dotsAnimations[i] = (AnimatorSet)AnimatorInflater.loadAnimator((Context)this.getContext(), (int)R.animator.intercom_admin_is_typing);
            this.dotsAnimations[i].setStartDelay((long)(i * 100));
        }
        this.setupEndCondition();
    }

    public void beginAnimation() {
        if (!this.animating) {
            this.animating = true;
            this.animateDots.run();
        }
    }

    public void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    private void setupEndCondition() {
        this.postDelayed(this.endAnimation, TimeUnit.SECONDS.toMillis(10L));
    }

    public void renewTypingAnimation() {
        this.removeCallbacks(this.endAnimation);
        this.setupEndCondition();
    }

    public void cancelTypingAnimation() {
        this.endAnimation.run();
    }

    public static interface Listener {
        public void onAdminTypingAnimationEnded(AdminIsTypingView var1);
    }
}

