/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.SuppressLint;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.conversation.ConversationContentPresenter;
import io.intercom.android.sdk.conversation.JavascriptRunner;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.com.google.gson.Gson;
import java.util.List;

class WebViewConversationContentPresenter
implements ConversationContentPresenter {
    private static final String WEB_PAGE_URL = "https://js.intercomcdn.com/mobile.html";
    private final WebView webView;
    private final View container;
    private final AppIdentity appIdentity;
    private final UserIdentity userIdentity;
    private final ConversationContentPresenter.Host host;
    private final Gson gson;
    private final JavascriptRunner jsRunner;
    private HostWrapper hostWrapper;

    WebViewConversationContentPresenter(WebView webView, View container, AppIdentity appIdentity, UserIdentity userIdentity, ConversationContentPresenter.Host host, Gson gson, JavascriptRunner jsRunner) {
        this.webView = webView;
        this.container = container;
        this.appIdentity = appIdentity;
        this.userIdentity = userIdentity;
        this.host = host;
        this.gson = gson;
        this.jsRunner = jsRunner;
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void setup() {
        this.container.setVisibility(0);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.loadUrl(WEB_PAGE_URL);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                WebViewConversationContentPresenter.this.jsRunner.runPendingScripts();
            }
        });
        this.hostWrapper = new HostWrapper(this.host, this.webView, this.gson);
        this.webView.addJavascriptInterface((Object)this.hostWrapper, "AndroidHost");
        this.webView.setBackgroundResource(R.color.intercom_full_transparent_full_white);
        this.jsRunner.run("mobileApp.bridge.onConversationUpdated = function(conversation) {AndroidHost.onConversationUpdated(JSON.stringify(conversation));};");
        this.jsRunner.run("configureStyleSheet();");
    }

    @Override
    public void smoothScrollToTop() {
        this.scrollToTop();
    }

    @Override
    public void scrollToTop() {
        this.webView.scrollTo(0, 0);
    }

    @Override
    public void scrollToBottom() {
        this.webView.scrollTo(0, this.webView.getContentHeight());
    }

    @Override
    public boolean isAtBottom() {
        return this.webView.getScrollY() + this.webView.getHeight() >= this.webView.getContentHeight();
    }

    @Override
    public void onProfileScrolled() {
    }

    @Override
    public void onGlobalLayout() {
    }

    @Override
    public void onNewPartReceived() {
    }

    @Override
    public void showErrorView() {
    }

    @Override
    public void showLoadingView() {
    }

    @Override
    public void showContentView() {
    }

    @Override
    public void onAdminStartedTyping(AdminIsTypingEvent event) {
        TypingAdmin admin = new TypingAdmin(event.getAdminId(), event.getAdminName(), event.getAdminAvatarUrl());
        this.jsRunner.run("mobileApp.handleAdminTyping(" + this.gson.toJson((Object)admin) + ");");
    }

    @Override
    public void onNewCommentEventReceived(NewCommentEvent event) {
        this.jsRunner.run("mobileApp.handleNewPart(" + this.sessionAsJsonString() + ");");
    }

    @Override
    public void fetchConversation(String conversationId) {
        this.jsRunner.run("mobileApp.updateConversation(" + this.sessionAsJsonString() + ",'" + conversationId + "');");
    }

    private String sessionAsJsonString() {
        return this.gson.toJson((Object)new Session(this.appIdentity.appId(), this.getUserIdForConversation()));
    }

    @VisibleForTesting
    String getUserIdForConversation() {
        String userId = this.userIdentity.getUserId();
        if (!userId.isEmpty()) {
            return userId;
        }
        String email = this.userIdentity.getEmail();
        if (!email.isEmpty()) {
            return email;
        }
        return this.userIdentity.getAnonymousId();
    }

    @Override
    public void onPartClicked(Part part) {
    }

    @Override
    public void sendPart(List<Block.Builder> blockBuilders, Part part) {
        this.jsRunner.run("mobileApp.createPart(" + this.sessionAsJsonString() + "," + this.gson.toJson(blockBuilders) + ");");
    }

    @Override
    public Part addSendingPart(List<Block.Builder> blocks) {
        return new Part();
    }

    @Override
    public void uploadImage(List<Block.Builder> blocks, GalleryImage galleryImage) {
    }

    @Override
    public void onNewConversation(NewConversationEvent event) {
    }

    @Override
    public void onReplyDelivered(ReplyEvent event) {
    }

    @Override
    public void onConversationFetched(ConversationEvent event) {
    }

    @Override
    public void cleanup() {
        this.jsRunner.clearPendingScripts();
    }

    private static class TypingAdmin {
        final String id;
        final String firstName;
        final String avatarUrl;

        TypingAdmin(String id2, String firstName, String avatarUrl) {
            this.id = id2;
            this.firstName = firstName;
            this.avatarUrl = avatarUrl;
        }
    }

    private static class Session {
        final String appId;
        final String userId;

        Session(String appId, String userId) {
            this.appId = appId;
            this.userId = userId;
        }
    }

    private static class HostWrapper {
        private final ConversationContentPresenter.Host host;
        private final WebView webView;
        private final Gson gson;

        HostWrapper(ConversationContentPresenter.Host host, WebView webView, Gson gson) {
            this.host = host;
            this.webView = webView;
            this.gson = gson;
        }

        @JavascriptInterface
        public void onConversationUpdated(final String conversationJson) {
            this.webView.post(new Runnable(){

                @Override
                public void run() {
                    HostWrapper.this.host.onConversationUpdated(((Conversation.Builder)HostWrapper.this.gson.fromJson(conversationJson, Conversation.Builder.class)).build());
                }
            });
        }
    }
}

