/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.models.events.realtime.UserContentSeenByAdminEvent;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.com.squareup.otto.Bus;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class NexusWrapper
extends NexusClient
implements NexusListener {
    private static final String CONVERSATION_ID = "conversationId";
    private static final String ADMIN_ID = "adminId";
    private static final String ADMIN_NAME = "adminName";
    private static final String ADMIN_AVATAR = "adminAvatar";
    private final Twig twig;
    private final Bus bus;
    private final Store<State> store;
    private final long debouncePeriodMs;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    @Nullable
    private ScheduledFuture actionFuture;

    public NexusWrapper(Twig twig, Bus bus, Store<State> store, long debouncePeriodMs) {
        super(twig);
        this.twig = twig;
        this.bus = bus;
        this.store = store;
        this.debouncePeriodMs = debouncePeriodMs;
    }

    public void connect(final NexusConfig config, final boolean shouldSendPresence) {
        if (config.getEndpoints().isEmpty()) {
            this.twig.w("No realtime endpoints present so we can't connect", new Object[0]);
            return;
        }
        this.removeCallbacks();
        this.actionFuture = this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                NexusWrapper.this.connectNow(config, shouldSendPresence);
            }
        }, this.debouncePeriodMs, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    void connectNow(NexusConfig config, boolean shouldSendPresence) {
        if (this.isConnected()) {
            return;
        }
        super.connect(config, shouldSendPresence);
        this.setTopics(Collections.singletonList("*"));
        this.addEventListener(this);
    }

    public void disconnect() {
        this.removeCallbacks();
        this.actionFuture = this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                NexusWrapper.this.disconnectNow();
            }
        }, this.debouncePeriodMs, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    void disconnectNow() {
        this.removeEventListener(this);
        super.disconnect();
    }

    private void removeCallbacks() {
        if (this.actionFuture != null) {
            this.actionFuture.cancel(false);
        }
    }

    public void notifyEvent(NexusEvent event) {
        String conversationId = event.getEventData().optString(CONVERSATION_ID);
        switch (event.getEventType()) {
            case AdminIsTyping: {
                this.logKnownEvent(event);
                String adminId = event.getEventData().optString(ADMIN_ID);
                String adminName = event.getEventData().optString(ADMIN_NAME);
                String adminAvatarUrl = event.getEventData().optString(ADMIN_AVATAR);
                this.bus.post((Object)new AdminIsTypingEvent(adminId, conversationId, adminName, adminAvatarUrl));
                break;
            }
            case NewComment: {
                this.logKnownEvent(event);
                this.bus.post((Object)new NewCommentEvent(conversationId));
                break;
            }
            case CreateConversation: {
                this.logKnownEvent(event);
                this.store.dispatch(Actions.createConversationEventReceived());
                break;
            }
            case UserContentSeenByAdmin: {
                this.logKnownEvent(event);
                this.bus.post((Object)new UserContentSeenByAdminEvent(conversationId));
                break;
            }
            case ConversationSeen: {
                this.logKnownEvent(event);
                this.store.dispatch(Actions.conversationMarkedAsRead(conversationId));
                break;
            }
            default: {
                this.twig.internal("Nexus", "Unexpected event: " + event.getEventType());
            }
        }
    }

    private void logKnownEvent(NexusEvent event) {
        this.twig.internal("Nexus", "Received " + event.getEventType() + " event");
    }

    public void onConnect() {
    }

    public void onConnectFailed() {
    }

    public void onShutdown() {
    }
}

