/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.bitmap;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.os.Build;
import android.util.Log;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;

public final class TransformationUtils {
    private static final String TAG = "TransformationUtils";
    public static final int PAINT_FLAGS = 6;

    private TransformationUtils() {
    }

    public static Bitmap centerCrop(Bitmap recycled, Bitmap toCrop, int width, int height) {
        float scale;
        if (toCrop == null) {
            return null;
        }
        if (toCrop.getWidth() == width && toCrop.getHeight() == height) {
            return toCrop;
        }
        float dx = 0.0f;
        float dy = 0.0f;
        Matrix m = new Matrix();
        if (toCrop.getWidth() * height > width * toCrop.getHeight()) {
            scale = (float)height / (float)toCrop.getHeight();
            dx = ((float)width - (float)toCrop.getWidth() * scale) * 0.5f;
        } else {
            scale = (float)width / (float)toCrop.getWidth();
            dy = ((float)height - (float)toCrop.getHeight() * scale) * 0.5f;
        }
        m.setScale(scale, scale);
        m.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        Bitmap result = recycled != null ? recycled : Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)TransformationUtils.getSafeConfig(toCrop));
        TransformationUtils.setAlpha(toCrop, result);
        Canvas canvas = new Canvas(result);
        Paint paint = new Paint(6);
        canvas.drawBitmap(toCrop, m, paint);
        return result;
    }

    public static Bitmap fitCenter(Bitmap toFit, BitmapPool pool, int width, int height) {
        if (toFit.getWidth() == width && toFit.getHeight() == height) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"requested target size matches input, returning input");
            }
            return toFit;
        }
        float widthPercentage = (float)width / (float)toFit.getWidth();
        float heightPercentage = (float)height / (float)toFit.getHeight();
        float minPercentage = Math.min(widthPercentage, heightPercentage);
        int targetWidth = (int)(minPercentage * (float)toFit.getWidth());
        int targetHeight = (int)(minPercentage * (float)toFit.getHeight());
        if (toFit.getWidth() == targetWidth && toFit.getHeight() == targetHeight) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"adjusted target size matches input, returning input");
            }
            return toFit;
        }
        Bitmap.Config config = TransformationUtils.getSafeConfig(toFit);
        Bitmap toReuse = pool.get(targetWidth, targetHeight, config);
        if (toReuse == null) {
            toReuse = Bitmap.createBitmap((int)targetWidth, (int)targetHeight, (Bitmap.Config)config);
        }
        TransformationUtils.setAlpha(toFit, toReuse);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("request: " + width + "x" + height));
            Log.v((String)TAG, (String)("toFit:   " + toFit.getWidth() + "x" + toFit.getHeight()));
            Log.v((String)TAG, (String)("toReuse: " + toReuse.getWidth() + "x" + toReuse.getHeight()));
            Log.v((String)TAG, (String)("minPct:   " + minPercentage));
        }
        Canvas canvas = new Canvas(toReuse);
        Matrix matrix = new Matrix();
        matrix.setScale(minPercentage, minPercentage);
        Paint paint = new Paint(6);
        canvas.drawBitmap(toFit, matrix, paint);
        return toReuse;
    }

    @TargetApi(value=12)
    public static void setAlpha(Bitmap toTransform, Bitmap outBitmap) {
        if (Build.VERSION.SDK_INT >= 12 && outBitmap != null) {
            outBitmap.setHasAlpha(toTransform.hasAlpha());
        }
    }

    @Deprecated
    @TargetApi(value=5)
    public static int getOrientation(String pathToOriginal) {
        int degreesToRotate = 0;
        try {
            ExifInterface exif = new ExifInterface(pathToOriginal);
            int orientation = exif.getAttributeInt("Orientation", 0);
            return TransformationUtils.getExifOrientationDegrees(orientation);
        }
        catch (Exception e) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)("Unable to get orientation for image with path=" + pathToOriginal), (Throwable)e);
            }
            return degreesToRotate;
        }
    }

    @Deprecated
    public static Bitmap orientImage(String pathToOriginal, Bitmap imageToOrient) {
        int degreesToRotate = TransformationUtils.getOrientation(pathToOriginal);
        return TransformationUtils.rotateImage(imageToOrient, degreesToRotate);
    }

    public static Bitmap rotateImage(Bitmap imageToOrient, int degreesToRotate) {
        Bitmap result;
        block3: {
            result = imageToOrient;
            try {
                if (degreesToRotate != 0) {
                    Matrix matrix = new Matrix();
                    matrix.setRotate((float)degreesToRotate);
                    result = Bitmap.createBitmap((Bitmap)imageToOrient, (int)0, (int)0, (int)imageToOrient.getWidth(), (int)imageToOrient.getHeight(), (Matrix)matrix, (boolean)true);
                }
            }
            catch (Exception e) {
                if (!Log.isLoggable((String)TAG, (int)6)) break block3;
                Log.e((String)TAG, (String)"Exception when trying to orient image", (Throwable)e);
            }
        }
        return result;
    }

    public static int getExifOrientationDegrees(int exifOrientation) {
        int degreesToRotate;
        switch (exifOrientation) {
            case 5: 
            case 6: {
                degreesToRotate = 90;
                break;
            }
            case 3: 
            case 4: {
                degreesToRotate = 180;
                break;
            }
            case 7: 
            case 8: {
                degreesToRotate = 270;
                break;
            }
            default: {
                degreesToRotate = 0;
            }
        }
        return degreesToRotate;
    }

    public static Bitmap rotateImageExif(Bitmap toOrient, BitmapPool pool, int exifOrientation) {
        Matrix matrix = new Matrix();
        TransformationUtils.initializeMatrixForRotation(exifOrientation, matrix);
        if (matrix.isIdentity()) {
            return toOrient;
        }
        RectF newRect = new RectF(0.0f, 0.0f, (float)toOrient.getWidth(), (float)toOrient.getHeight());
        matrix.mapRect(newRect);
        int newWidth = Math.round(newRect.width());
        int newHeight = Math.round(newRect.height());
        Bitmap.Config config = TransformationUtils.getSafeConfig(toOrient);
        Bitmap result = pool.get(newWidth, newHeight, config);
        if (result == null) {
            result = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)config);
        }
        matrix.postTranslate(-newRect.left, -newRect.top);
        Canvas canvas = new Canvas(result);
        Paint paint = new Paint(6);
        canvas.drawBitmap(toOrient, matrix, paint);
        return result;
    }

    private static Bitmap.Config getSafeConfig(Bitmap bitmap) {
        return bitmap.getConfig() != null ? bitmap.getConfig() : Bitmap.Config.ARGB_8888;
    }

    static void initializeMatrixForRotation(int exifOrientation, Matrix matrix) {
        switch (exifOrientation) {
            case 2: {
                matrix.setScale(-1.0f, 1.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f);
                break;
            }
            case 4: {
                matrix.setRotate(180.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 6: {
                matrix.setRotate(90.0f);
                break;
            }
            case 7: {
                matrix.setRotate(-90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 8: {
                matrix.setRotate(-90.0f);
                break;
            }
        }
    }
}

