/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.text.TextUtils;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;

public class ImageUtils {
    public static double getAspectRatio(int imageWidth, int imageHeight) {
        double aspectRatio = 1.0 * (double)imageHeight / (double)imageWidth;
        if (Double.isNaN(aspectRatio)) {
            aspectRatio = 0.0;
        }
        return aspectRatio;
    }

    public static int getAspectHeight(int imageWidth, double aspectRatio) {
        return (int)((double)imageWidth * aspectRatio);
    }

    public static int getBoundedWidth(int width, int height, int eglMaxTextureSize, boolean openGlEnabled) {
        double aspectRatio = ImageUtils.getAspectRatio(width, height);
        int result = !openGlEnabled || eglMaxTextureSize == 0 ? width : (aspectRatio <= 1.0 ? Math.min(eglMaxTextureSize, width) : (int)Math.min((double)width, (double)width / (1.0 * (double)height / (double)eglMaxTextureSize)));
        return result;
    }

    public static int getBoundedHeight(int width, int height, int eglMaxTextureSize, boolean openGlEnabled) {
        double aspectRatio = ImageUtils.getAspectRatio(width, height);
        int result = !openGlEnabled || eglMaxTextureSize == 0 ? height : (aspectRatio > 1.0 ? Math.min(eglMaxTextureSize, height) : (int)Math.min((double)height, (double)height / (1.0 * (double)width / (double)eglMaxTextureSize)));
        return result;
    }

    public static DiskCacheStrategy getDiskCacheStrategy(String url) {
        return ImageUtils.isGif(url) ? DiskCacheStrategy.SOURCE : DiskCacheStrategy.RESULT;
    }

    public static boolean isGif(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && url.endsWith(".gif");
    }
}

