/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.overlay.DefaultLauncher;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;

class DefaultLauncherPresenter
implements DefaultLauncher.Listener {
    private final LayoutInflater inflater;
    private final LauncherOpenBehaviour openBehaviour;
    private final MetricsStore metricsStore;
    private final MetricFactory metricFactory;
    @Nullable
    private DefaultLauncher defaultLauncher;
    private int previousUnreadCount = 0;

    DefaultLauncherPresenter(LayoutInflater inflater, LauncherOpenBehaviour openBehaviour, MetricsStore metricsStore, MetricFactory metricFactory) {
        this.inflater = inflater;
        this.openBehaviour = openBehaviour;
        this.metricsStore = metricsStore;
        this.metricFactory = metricFactory;
    }

    void displayLauncherOnAttachedRoot(ViewGroup root, @ColorInt int backgroundColor) {
        if (this.defaultLauncher != null && !this.defaultLauncher.isAttachedToRoot(root)) {
            this.defaultLauncher.removeView();
            this.defaultLauncher = null;
        }
        if (this.defaultLauncher == null) {
            this.defaultLauncher = new DefaultLauncher(root, this.inflater, this);
            this.defaultLauncher.fadeOnScreen();
        }
        this.setLauncherBackgroundColor(backgroundColor);
        this.setUnreadCount(this.previousUnreadCount);
    }

    DefaultLauncher getAndUnsetLauncher() {
        DefaultLauncher localLauncher = this.defaultLauncher;
        this.defaultLauncher = null;
        return localLauncher;
    }

    void setLauncherBackgroundColor(@ColorInt int backgroundColor) {
        if (this.defaultLauncher != null) {
            this.defaultLauncher.setBackgroundColor(backgroundColor);
        }
    }

    void removeLauncher() {
        if (this.defaultLauncher != null) {
            this.defaultLauncher.fadeOffScreen(null);
            this.defaultLauncher = null;
        }
    }

    public boolean isDisplaying() {
        return this.defaultLauncher != null;
    }

    public void setUnreadCount(int unreadCount) {
        if (this.isDisplaying()) {
            String unreadCountText = String.valueOf(unreadCount);
            if (unreadCount > this.previousUnreadCount) {
                this.metricsStore.track(this.metricFactory.receivedNotificationFromBadgeWhenMessengerClosed(unreadCountText));
            }
            if (unreadCount > 0) {
                this.defaultLauncher.setBadgeCount(unreadCountText);
            } else {
                this.defaultLauncher.hideBadgeCount();
            }
        }
        this.previousUnreadCount = unreadCount;
    }

    @Override
    public void onLauncherClicked(Context context) {
        this.openBehaviour.openMessenger(context);
    }
}

