/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.content.Context;
import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.Blocks;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.logger.TwigFactory;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.overlay.ChatNotification;
import io.intercom.android.sdk.overlay.InAppNotification;

class ChatFull
extends ChatNotification {
    private final MetricsStore metricsStore;
    private final MetricFactory metricFactory;

    public ChatFull(Context localisedContext, Conversation conversation, int position, int screenHeight, InAppNotification.Listener listener, MetricsStore metricsStore, MetricFactory metricFactory) {
        super(localisedContext, conversation, position, screenHeight, listener);
        this.metricsStore = metricsStore;
        this.metricFactory = metricFactory;
    }

    @Override
    protected ViewGroup inflateChatRootView(ViewGroup parent, LayoutInflater inflater) {
        final ViewGroup root = (ViewGroup)inflater.inflate(R.layout.intercom_preview_chat_full_overlay, parent, false);
        Blocks blocks = new Blocks(this.localisedContext, TwigFactory.getBlocksTwig());
        Injector injector = Injector.get();
        ViewHolderGenerator generator = new ViewHolderGenerator(this.localisedContext, new UploadingImageCache(), injector, injector.getAppIdentity(), this.conversation.getId());
        BlocksViewHolder chatFullHolder = generator.getChatFullHolder();
        LinearLayout renderedBlocks = blocks.createBlocks(this.conversation.getLastPart().getBlocks(), chatFullHolder);
        final ViewGroup blockContainer = (ViewGroup)root.findViewById(R.id.chathead_text_container);
        blockContainer.addView((View)renderedBlocks);
        blockContainer.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                blockContainer.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                int blockContentHeight = blockContainer.getMeasuredHeight();
                int bottomMargin = ((ViewGroup.MarginLayoutParams)blockContainer.getLayoutParams()).bottomMargin;
                Resources res = ChatFull.this.localisedContext.getResources();
                int topMargin = res.getDimensionPixelSize(R.dimen.intercom_chat_full_top_margin);
                int bottomPadding = res.getDimensionPixelSize(R.dimen.intercom_bottom_padding);
                int availableContentSpace = ChatFull.this.screenHeight - topMargin - bottomMargin - bottomPadding;
                if (blockContentHeight >= availableContentSpace) {
                    View fade = root.findViewById(R.id.chat_overlay_overflow_fade);
                    fade.setVisibility(0);
                    return false;
                }
                return true;
            }
        });
        injector.getApi().markConversationAsRead(this.conversation.getId());
        this.metricsStore.track(this.metricFactory.viewedInAppFromFull(this.conversation.getId(), this.conversation.getLastPart().getId()));
        return root;
    }

    @Override
    protected View getContentContainer() {
        return ((ViewGroup)this.overlayRoot.findViewById(R.id.chathead_text_container)).getChildAt(1);
    }

    @Override
    protected void updateContentContainer(Part part) {
    }

    @Override
    public void update(Conversation conversation, Runnable updateEndAction) {
    }

    @Override
    protected void updateViewDataDuringReplyPulse() {
    }
}

