/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import io.intercom.android.sdk.logger.TwigFactory;
import io.intercom.android.sdk.twig.Twig;

public class IntercomPushManager {
    private static final String PREFS_SENDER_ID = "intercom_sender_id";
    public static final String MULTIPLE_NOTIFICATIONS = "multiple_notifications";
    public static final String PUSH_ONLY_ID = "push_only_convo_id";
    public static final String INTERCOM_PUSH_KEY = "intercom_push_key";
    public static final String HOST_APP_INTENT = "host_app_intent";
    public static final String INTERCOM_PUSH_PATH = "intercom_push_notification_path";
    private static final Twig TWIG = TwigFactory.getLogger();

    static void startGcmRegistrationService(Context context) {
        try {
            context.startService(new Intent(context, IntercomPushManager.getGcmRegistrationServiceClass()));
        }
        catch (SecurityException e) {
            TWIG.e("Cannot start the GCM registration service due to a SecurityException: " + e.getMessage(), new Object[0]);
        }
    }

    static IntercomPushIntegrationType getInstalledModuleType() {
        IntercomPushIntegrationType integrationType = IntercomPushIntegrationType.NONE;
        boolean fcmInstalled = IntercomPushManager.fcmModuleInstalled();
        boolean gcmInstalled = IntercomPushManager.gcmModuleInstalled();
        if (fcmInstalled && gcmInstalled) {
            TWIG.internal("Both FCM and GCM are installed");
            integrationType = IntercomPushIntegrationType.BOTH;
        } else if (fcmInstalled) {
            TWIG.internal("FCM is installed");
            integrationType = IntercomPushIntegrationType.FCM;
        } else if (gcmInstalled) {
            TWIG.internal("GCM is installed");
            integrationType = IntercomPushIntegrationType.GCM;
        }
        return integrationType;
    }

    private static boolean gcmModuleInstalled() {
        return IntercomPushManager.getGcmListenerClass() != null && IntercomPushManager.getGcmRegistrationServiceClass() != null;
    }

    private static boolean fcmModuleInstalled() {
        return IntercomPushManager.getFcmMessengerClass() != null && IntercomPushManager.getFcmInstanceIdClass() != null;
    }

    static void cacheSenderId(Context context, String senderId) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        prefs.edit().putString(PREFS_SENDER_ID, senderId).apply();
    }

    public static String getSenderId(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        return prefs.getString(PREFS_SENDER_ID, "");
    }

    private static Class getGcmListenerClass() {
        try {
            return Class.forName("io.intercom.android.sdk.gcm.IntercomGcmListenerService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class getGcmRegistrationServiceClass() {
        try {
            return Class.forName("io.intercom.android.sdk.gcm.IntercomGcmRegistrationService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class getFcmMessengerClass() {
        try {
            return Class.forName("io.intercom.android.sdk.fcm.IntercomFcmMessengerService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class getFcmInstanceIdClass() {
        try {
            return Class.forName("io.intercom.android.sdk.fcm.IntercomFcmInstanceIDService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static enum IntercomPushIntegrationType {
        BOTH,
        FCM,
        GCM,
        NONE;

    }
}

