/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.support.annotation.NonNull;
import android.util.LruCache;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusEventType;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.android.sdk.twig.Twig;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class NexusEventPropagator
implements NexusListener {
    private final LruCache<String, Boolean> cache = new LruCache(100);
    private final List<NexusListener> listeners = new CopyOnWriteArrayList<NexusListener>();
    private final Twig twig;

    public NexusEventPropagator(Twig twig) {
        this.twig = twig;
    }

    void addListener(@NonNull NexusListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(@NonNull NexusListener listener) {
        this.listeners.remove(listener);
    }

    void cacheEvent(NexusEvent event) {
        this.cache.put((Object)event.getGuid(), (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEvent(@NonNull NexusEvent event) {
        if (event.getEventType() != NexusEventType.UNKNOWN) {
            LruCache<String, Boolean> lruCache = this.cache;
            synchronized (lruCache) {
                if (this.cache.get((Object)event.getGuid()) == null) {
                    this.cache.put((Object)event.getGuid(), (Object)true);
                    this.twig.internal("notifying listeners of event: " + (Object)((Object)event.getEventType()));
                    for (NexusListener listener : this.listeners) {
                        listener.notifyEvent(event);
                    }
                } else {
                    this.twig.internal("dropping event, already in cache: " + event.toStringEncodedJsonObject());
                }
            }
        }
    }

    @Override
    public void onConnect() {
        this.twig.d("notifying listeners that a connection opened", new Object[0]);
        for (NexusListener listener : this.listeners) {
            listener.onConnect();
        }
    }

    @Override
    public void onConnectFailed() {
        this.twig.d("notifying listeners that a connection failed to open", new Object[0]);
        for (NexusListener listener : this.listeners) {
            listener.onConnectFailed();
        }
    }
}

