/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.OrderedListBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.UnorderedListBlock;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.spans.OrderedListSpan;
import io.intercom.android.sdk.spans.UnorderedListSpan;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.HtmlCompat;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;
import java.util.List;

class ListBlock
implements OrderedListBlock,
UnorderedListBlock {
    private static final int LARGE_TEXT_SIZE_SP = 16;
    private static final int SMALL_TEXT_SIZE_SP = 14;
    private final StyleType style;
    private final AppConfig.Provider appConfigProvider;
    private final Context context;

    public ListBlock(Context context, StyleType style, AppConfig.Provider appConfigProvider) {
        this.context = context;
        this.style = style;
        this.appConfigProvider = appConfigProvider;
    }

    public View addOrderedList(List<String> items, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview = this.getListStyledTextView();
        int lineIndent = (int)this.context.getResources().getDimension(R.dimen.intercom_list_indentation);
        CharSequence chars = "";
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            String item = items.get(i);
            if (item.isEmpty()) continue;
            String delimiter = i < size - 1 ? "<br />" : "";
            Spanned source = HtmlCompat.fromHtml(item + delimiter);
            SpannableString spannableString = new SpannableString((CharSequence)source);
            spannableString.setSpan((Object)new OrderedListSpan(lineIndent, i + 1 + "."), 0, source.length(), 0);
            chars = TextUtils.concat((CharSequence[])new CharSequence[]{chars, spannableString});
        }
        textview.setText(chars);
        BlockUtils.setLayoutMarginsAndGravity((View)textview, 3, isLastObject);
        return textview;
    }

    public View addUnorderedList(List<String> items, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview = this.getListStyledTextView();
        int lineIndent = (int)this.context.getResources().getDimension(R.dimen.intercom_list_indentation);
        CharSequence chars = "";
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            String item = items.get(i);
            if (item.isEmpty()) continue;
            String delimiter = i < size - 1 ? "<br />" : "";
            Spanned source = HtmlCompat.fromHtml(item + delimiter);
            SpannableString spannableString = new SpannableString((CharSequence)source);
            spannableString.setSpan((Object)new UnorderedListSpan(lineIndent, this.context), 0, source.length(), 0);
            chars = TextUtils.concat((CharSequence[])new CharSequence[]{chars, spannableString});
        }
        textview.setText(chars);
        BlockUtils.setLayoutMarginsAndGravity((View)textview, 3, isLastObject);
        return textview;
    }

    private TextView getListStyledTextView() {
        TextView textview = new TextView(this.context);
        textview.setLinkTextColor(this.appConfigProvider.getAppConfig().getBaseColor());
        BlockUtils.createLayoutParams((View)textview, -2, -2);
        BlockUtils.setMarginLeft((View)textview, 4);
        switch (this.style) {
            case ADMIN: {
                int color2 = ContextCompat.getColor((Context)this.context, (int)R.color.intercom_grey_800);
                this.styleAsChatList(textview, color2);
                textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                break;
            }
            case NOTE: 
            case CONTAINER_CARD: {
                int color3 = ContextCompat.getColor((Context)this.context, (int)R.color.intercom_grey_700);
                this.styleAsAnnouncementList(textview, color3);
                textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                break;
            }
            case POST: {
                int color4 = ContextCompat.getColor((Context)this.context, (int)R.color.intercom_white);
                this.styleAsAnnouncementList(textview, color4);
                textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                break;
            }
            case CHAT_FULL: {
                int color5 = ContextCompat.getColor((Context)this.context, (int)R.color.intercom_grey_800);
                this.styleAsChatList(textview, color5);
                break;
            }
            default: {
                int color6 = ContextCompat.getColor((Context)this.context, (int)R.color.intercom_white);
                this.styleAsChatList(textview, color6);
                textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
            }
        }
        return textview;
    }

    private void styleAsChatList(TextView textview, int colour) {
        textview.setTextSize(14.0f);
        textview.setTextColor(colour);
        BlockUtils.setDefaultMarginBottom((View)textview);
        BlockUtils.setSmallLineSpacing(textview);
    }

    private void styleAsAnnouncementList(TextView textview, int colour) {
        textview.setTextSize(16.0f);
        textview.setTextColor(colour);
        BlockUtils.setMarginBottom((View)textview, 16);
        BlockUtils.setLargeLineSpacing(textview);
    }
}

