/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.utilities.NetworkState;

public class ConnectivityBroadcastReceiver
extends BroadcastReceiver {
    private boolean listening;
    private NetworkState state;
    private final ConnectivityUpdateListener connectivityUpdateListener;

    public ConnectivityBroadcastReceiver(ConnectivityUpdateListener connectivityUpdateListener) {
        this.connectivityUpdateListener = connectivityUpdateListener;
        this.listening = false;
        this.state = NetworkState.UNKNOWN;
    }

    public void onReceive(@Nullable Context context, @Nullable Intent intent) {
        if (intent == null) {
            return;
        }
        String action = intent.getAction();
        if (!"android.net.conn.CONNECTIVITY_CHANGE".equals(action) || !this.listening) {
            return;
        }
        this.state = intent.getBooleanExtra("noConnectivity", false) ? NetworkState.NOT_CONNECTED : NetworkState.CONNECTED;
        this.connectivityUpdateListener.onUpdate();
    }

    public boolean isListening() {
        return this.listening;
    }

    public void setListening(boolean listening) {
        this.listening = listening;
    }

    public NetworkState getState() {
        return this.state;
    }

    public static interface ConnectivityUpdateListener {
        public void onUpdate();
    }
}

