/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.content.Context;
import android.media.SoundPool;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.logger.IntercomLogger;

public class SoundPlayer {
    private final SoundPool soundPool = new SoundPool(1, 5, 0);
    final int birdy1Id;
    final int wood1Id;
    final int wood2Id;
    final int wood3Id;
    boolean birdy1Loaded;
    boolean wood1Loaded;
    boolean wood3Loaded;
    boolean wood2Loaded;

    public SoundPlayer(Context context) {
        this.birdy1Id = this.soundPool.load(context, R.raw.intercom_birdy_done_1, 1);
        this.wood1Id = this.soundPool.load(context, R.raw.intercom_wood_done_1, 1);
        this.wood2Id = this.soundPool.load(context, R.raw.intercom_wood_done_2, 1);
        this.wood3Id = this.soundPool.load(context, R.raw.intercom_wood_done_3, 1);
        this.soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                if (status == 0) {
                    if (sampleId == SoundPlayer.this.birdy1Id) {
                        SoundPlayer.this.birdy1Loaded = true;
                    } else if (sampleId == SoundPlayer.this.wood1Id) {
                        SoundPlayer.this.wood1Loaded = true;
                    } else if (sampleId == SoundPlayer.this.wood2Id) {
                        SoundPlayer.this.wood2Loaded = true;
                    } else if (sampleId == SoundPlayer.this.wood3Id) {
                        SoundPlayer.this.wood3Loaded = true;
                    }
                }
            }
        });
    }

    public void playReplyFailSound() {
        if (this.wood1Loaded && Injector.get().getAppIdentity().getAppConfig().isAudioEnabled()) {
            IntercomLogger.internal("sounds", "playing user reply fail sound");
            this.soundPool.play(this.wood1Id, 1.0f, 1.0f, 1, 0, 1.0f);
        }
    }

    public void playReplySendingSound() {
        if (this.wood2Loaded && Injector.get().getAppIdentity().getAppConfig().isAudioEnabled()) {
            IntercomLogger.internal("sounds", "playing user reply sending sound");
            this.soundPool.play(this.wood2Id, 1.0f, 1.0f, 1, 0, 1.0f);
        }
    }

    public void playReplySuccessSound() {
        if (this.wood3Loaded && Injector.get().getAppIdentity().getAppConfig().isAudioEnabled()) {
            IntercomLogger.internal("sounds", "playing user reply success sound");
            this.soundPool.play(this.wood3Id, 1.0f, 1.0f, 1, 0, 1.0f);
        }
    }

    public void playAdminReplySound() {
        if (this.birdy1Loaded && Injector.get().getAppIdentity().getAppConfig().isAudioEnabled()) {
            IntercomLogger.internal("sounds", "playing admin reply sound");
            this.soundPool.play(this.birdy1Id, 1.0f, 1.0f, 1, 0, 1.0f);
        }
    }
}

