/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.attachments;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.net.Uri;
import io.intercom.android.sdk.attachments.AttachmentUtils;
import io.intercom.android.sdk.attachments.FileUtils;
import java.io.File;

public class AttachmentData {
    private final String id;
    private final String fileName;
    private final String mimeType;
    private final long size;
    private final Uri uri;
    private final File file;
    private String path;
    private int imageWidth = 0;
    private int imageHeight = 0;

    public AttachmentData(Uri uri, String id2, Context context) {
        this.uri = uri;
        this.id = id2;
        this.path = FileUtils.getPath(context, uri);
        this.fileName = FileUtils.getFileName(context, uri);
        this.mimeType = AttachmentUtils.getMimeType(this.fileName);
        if (this.path.isEmpty()) {
            this.file = AttachmentUtils.getFile(context, uri);
            this.path = AttachmentUtils.getPath(this.file);
        } else {
            this.file = new File(this.path);
        }
        this.size = this.file.length();
        if (this.mimeType.contains("image")) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            AttachmentUtils.populateBitmapOptions(this.path, options);
            this.imageWidth = options.outWidth;
            this.imageHeight = options.outHeight;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public long getSize() {
        return this.size;
    }

    public Uri getUri() {
        return this.uri;
    }

    public File getFile() {
        return this.file;
    }
}

