/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine;

import android.util.Log;
import io.intercom.com.bumptech.glide.Priority;
import io.intercom.com.bumptech.glide.load.engine.DecodeJob;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.engine.executor.Prioritized;
import io.intercom.com.bumptech.glide.request.ResourceCallback;

class EngineRunnable
implements Runnable,
Prioritized {
    private static final String TAG = "EngineRunnable";
    private final Priority priority;
    private final EngineRunnableManager manager;
    private final DecodeJob<?, ?, ?> decodeJob;
    private Stage stage;
    private volatile boolean isCancelled;

    public EngineRunnable(EngineRunnableManager manager, DecodeJob<?, ?, ?> decodeJob, Priority priority) {
        this.manager = manager;
        this.decodeJob = decodeJob;
        this.stage = Stage.CACHE;
        this.priority = priority;
    }

    public void cancel() {
        this.isCancelled = true;
        this.decodeJob.cancel();
    }

    @Override
    public void run() {
        if (this.isCancelled) {
            return;
        }
        Exception exception = null;
        Resource<?> resource = null;
        try {
            resource = this.decode();
        }
        catch (Exception e) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Exception decoding", (Throwable)e);
            }
            exception = e;
        }
        if (this.isCancelled) {
            if (resource != null) {
                resource.recycle();
            }
            return;
        }
        if (resource == null) {
            this.onLoadFailed(exception);
        } else {
            this.onLoadComplete(resource);
        }
    }

    private boolean isDecodingFromCache() {
        return this.stage == Stage.CACHE;
    }

    private void onLoadComplete(Resource resource) {
        this.manager.onResourceReady(resource);
    }

    private void onLoadFailed(Exception e) {
        if (this.isDecodingFromCache()) {
            this.stage = Stage.SOURCE;
            this.manager.submitForSource(this);
        } else {
            this.manager.onException(e);
        }
    }

    private Resource<?> decode() throws Exception {
        if (this.isDecodingFromCache()) {
            return this.decodeFromCache();
        }
        return this.decodeFromSource();
    }

    private Resource<?> decodeFromCache() throws Exception {
        Resource<?> result;
        block3: {
            result = null;
            try {
                result = this.decodeJob.decodeResultFromCache();
            }
            catch (Exception e) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block3;
                Log.d((String)TAG, (String)("Exception decoding result from cache: " + e));
            }
        }
        if (result == null) {
            result = this.decodeJob.decodeSourceFromCache();
        }
        return result;
    }

    private Resource<?> decodeFromSource() throws Exception {
        return this.decodeJob.decodeFromSource();
    }

    @Override
    public int getPriority() {
        return this.priority.ordinal();
    }

    static interface EngineRunnableManager
    extends ResourceCallback {
        public void submitForSource(EngineRunnable var1);
    }

    private static enum Stage {
        CACHE,
        SOURCE;

    }
}

