/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.inbox.ConversationClickListener;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.NameUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.AuthorAvatarView;
import java.util.ArrayList;
import java.util.Collections;

class InboxRowViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private final TextView name;
    private final TextView timeStamp;
    private final TextView summary;
    private final ImageView conversationIndicator;
    private final AuthorAvatarView authorAvatar;
    @NonNull
    private final ConversationClickListener conversationClickListener;
    private final Store<State> store;
    private final TimeFormatter timeFormatter;

    InboxRowViewHolder(View itemView, @NonNull Store<State> store, @NonNull ConversationClickListener conversationClickListener, @NonNull TimeFormatter timeFormatter) {
        super(itemView);
        this.conversationClickListener = conversationClickListener;
        this.store = store;
        this.timeFormatter = timeFormatter;
        itemView.setOnClickListener((View.OnClickListener)this);
        this.authorAvatar = (AuthorAvatarView)itemView.findViewById(R.id.intercom_author_avatar);
        this.name = (TextView)itemView.findViewById(R.id.intercom_user_name);
        this.timeStamp = (TextView)itemView.findViewById(R.id.intercom_time_stamp);
        this.summary = (TextView)itemView.findViewById(R.id.intercom_message_summary);
        this.conversationIndicator = (ImageView)itemView.findViewById(R.id.intercom_conversation_indicator);
    }

    void bindData(Conversation conversation) {
        Part lastPart = conversation.getLastPart();
        Context context = this.itemView.getContext();
        if (lastPart.getParticipant().isUserWithId(Injector.get().getUserIdentity().getIntercomId())) {
            this.summary.setText((CharSequence)(context.getString(R.string.intercom_inbox_you) + ": " + lastPart.getSummary()));
        } else {
            this.summary.setText((CharSequence)lastPart.getSummary());
        }
        this.timeStamp.setText(this.timeFormatter.getFormattedTime(lastPart.getCreatedAt()));
        this.setRowParticipantDetails(conversation);
        if (!conversation.isRead()) {
            FontUtils.setRobotoMediumTypeface(this.name);
            this.summary.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_800));
            Drawable unreadDot = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_unread_dot);
            int baseColor = Injector.get().getAppIdentity().getAppConfig().getBaseColor();
            ((GradientDrawable)unreadDot).setColor(baseColor);
            this.timeStamp.setCompoundDrawablesWithIntrinsicBounds(unreadDot, null, null, null);
            this.timeStamp.setTextColor(baseColor);
        } else {
            this.name.setTypeface(Typeface.SANS_SERIF);
            this.summary.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_600));
            this.timeStamp.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            this.timeStamp.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_500));
        }
        if (conversation.isUserParticipated()) {
            this.conversationIndicator.setVisibility(0);
        } else {
            this.conversationIndicator.setVisibility(4);
        }
    }

    private void setRowParticipantDetails(Conversation conversation) {
        Participant admin = conversation.getLastAdmin();
        TeamPresence teamPresence = this.store.state().teamPresence();
        if (admin.hasDisplayName()) {
            this.setParticipantAvatar(admin);
            this.setAdminName(conversation, admin);
        } else if (teamPresence.isEmpty()) {
            this.setParticipantAvatar(admin);
            this.setTeamPresenceName(Injector.get().getAppIdentity().getAppConfig().getName());
        } else {
            this.setTeamPresenceAvatar(teamPresence);
            this.setTeamPresenceName(Injector.get().getAppIdentity().getAppConfig().getName());
        }
    }

    private void setTeamPresenceName(String appName) {
        this.name.setText((CharSequence)appName);
    }

    private void setAdminName(Conversation conversation, Participant admin) {
        ArrayList<Participant> admins = new ArrayList<Participant>();
        for (Participant participant : conversation.getParticipants().values()) {
            if (!participant.isAdmin()) continue;
            admins.add(participant);
        }
        this.name.setText((CharSequence)NameUtils.getFormattedAdmins(this.itemView.getContext(), admin, admins.size()));
    }

    private void setParticipantAvatar(Participant participant) {
        this.authorAvatar.loadAvatars(Collections.singletonList(participant));
    }

    private void setTeamPresenceAvatar(TeamPresence teamPresence) {
        this.authorAvatar.loadAvatars(teamPresence.getActiveAdmins());
    }

    public void onClick(View v) {
        int index = this.getAdapterPosition();
        if (index != -1) {
            this.conversationClickListener.onConversationClicked(index);
        }
    }
}

