/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.OvershootInterpolator;
import android.view.inputmethod.InputMethodManager;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.conversation.ConversationFragment;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.inbox.InboxFragment;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.events.CloseMessengerEvent;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.views.StatusBarThemer;
import io.intercom.com.squareup.otto.Subscribe;

public class IntercomMessengerActivity
extends IntercomBaseActivity
implements InboxFragment.Listener,
ConversationFragment.Listener {
    @VisibleForTesting
    protected static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    @VisibleForTesting
    static final String PARCEL_INITIAL_MESSAGE = "parcel_initial_message";
    @VisibleForTesting
    ValueAnimator colorAnimation;
    static final String SHOW_INBOX = "showInbox";
    static final String LAST_PARTICIPANT = "last_participant";
    private InboxFragment inboxFragment;
    private View containerView;
    private View background;
    private MetricFactory metricFactory;
    private MetricsStore metricStore;
    private boolean isTwoPane;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_messenger_activity_layout);
        this.isTwoPane = this.getResources().getBoolean(R.bool.intercom_is_two_pane);
        this.inboxFragment = InboxFragment.newInstance(this.isTwoPane);
        this.containerView = this.findViewById(R.id.messenger_container);
        if (this.containerView != null) {
            this.containerView.setVisibility(8);
        }
        Injector.init(this.getApplication());
        this.getFragmentManager().executePendingTransactions();
        this.showMessenger();
        Injector.get().getBus().register((Object)this);
        UserIdentity userIdentity = Injector.get().getUserIdentity();
        this.metricFactory = new MetricFactory(userIdentity);
        this.metricStore = Injector.get().getMetricsStore();
    }

    private int getScreenHeight() {
        return this.findViewById(0x1020002).getMeasuredHeight();
    }

    protected void onDestroy() {
        Injector.get().getBus().unregister((Object)this);
        super.onDestroy();
    }

    private void showMessenger() {
        Bundle data = this.getIntent().getExtras();
        String conversationId = "";
        String initialMessage = "";
        LastParticipatingAdmin lastParticipatingAdmin = LastParticipatingAdmin.NULL;
        boolean shouldShowInbox = false;
        if (data != null) {
            conversationId = data.getString(PARCEL_CONVERSATION_ID, "");
            initialMessage = data.getString(PARCEL_INITIAL_MESSAGE, "");
            shouldShowInbox = data.getBoolean(SHOW_INBOX);
            if (data.containsKey(LAST_PARTICIPANT)) {
                lastParticipatingAdmin = (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT);
            }
        }
        if (this.isTwoPane) {
            if (shouldShowInbox) {
                this.inboxFragment.setShouldOpenFirstConversation(true);
            } else {
                this.displayConversationFragment(conversationId, lastParticipatingAdmin, initialMessage);
            }
            this.displayInboxFragment();
        } else if (shouldShowInbox) {
            this.displayInboxFragment();
        } else {
            this.displayConversationFragment(conversationId, lastParticipatingAdmin, initialMessage);
        }
        this.background = this.getWindow().getDecorView();
        BackgroundUtils.animateBackground(ContextCompat.getColor((Context)this, (int)17170445), ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black), 200, this.background, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.background.post(new Runnable(){

                    @Override
                    public void run() {
                        IntercomMessengerActivity.this.animateSdkWindowIn();
                    }
                });
            }
        });
    }

    private void displayFragment(Fragment frag, String tag, boolean addToBackStack) {
        IntercomLogger.internal("frag", "displaying " + frag);
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        int fragmentId = frag instanceof ConversationFragment && this.isTwoPane ? R.id.conversation_fragment : R.id.inbox_fragment;
        transaction.replace(fragmentId, frag, tag);
        if (addToBackStack) {
            IntercomLogger.internal("frag", "adding " + frag + " to the back stack");
            transaction.addToBackStack(tag);
        }
        transaction.commitAllowingStateLoss();
    }

    private void displayInboxFragment() {
        this.displayFragment(this.inboxFragment, InboxFragment.class.getName(), false);
    }

    private void displayConversationFragment(String conversationId, LastParticipatingAdmin lastParticipatingAdmin, String initialMessage) {
        this.loadConversation(conversationId, lastParticipatingAdmin, false, false, initialMessage);
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 0) {
            this.metricStore.track(this.metricFactory.closedMessengerBackButton());
            this.closeMessenger();
        } else {
            this.trackMoveToConversationListMetric();
            super.onBackPressed();
        }
    }

    private void trackMoveToConversationListMetric() {
        ConversationFragment fragment = (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag(ConversationFragment.class.getName());
        if (fragment != null) {
            String conversationId = fragment.getConversationId();
            if (TextUtils.isEmpty((CharSequence)conversationId)) {
                this.metricStore.track(this.metricFactory.openConversationsListFromNewConversation());
            } else {
                this.metricStore.track(this.metricFactory.openConversationsListFromConversation(conversationId));
            }
        }
    }

    @Override
    public void loadConversation(String conversationId, LastParticipatingAdmin participant, boolean isRead, boolean addToBackStack, String initialMessage) {
        ConversationFragment fragment = ConversationFragment.newInstance(conversationId, participant, isRead, this.isTwoPane, initialMessage);
        this.displayFragment(fragment, ConversationFragment.class.getName(), addToBackStack);
    }

    @Override
    public void showErrorMessageDialog() {
        new AlertDialog.Builder((Context)this).setTitle(R.string.intercom_inbox_error_state_title).setMessage(R.string.intercom_message_error_message).setPositiveButton(R.string.intercom_tap_to_retry, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConversationFragment fragment = (ConversationFragment)IntercomMessengerActivity.this.getSupportFragmentManager().findFragmentByTag(ConversationFragment.class.getName());
                if (fragment != null) {
                    fragment.retryTapped();
                }
            }
        }).show();
    }

    private void animateSdkWindowIn() {
        this.containerView.setVisibility(0);
        this.containerView.setY((float)this.getScreenHeight());
        this.containerView.animate().y(0.0f).setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).setDuration(350L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.hideBackgroundColor();
                ConversationFragment fragment = (ConversationFragment)IntercomMessengerActivity.this.getSupportFragmentManager().findFragmentByTag(ConversationFragment.class.getName());
                if (fragment != null) {
                    fragment.sdkWindowFinishedAnimating();
                }
            }
        }).start();
    }

    private void closeMessenger() {
        this.hideKeyboard();
        this.showBackgroundColour();
        this.containerView.animate().y((float)this.getWindow().getDecorView().getHeight()).setInterpolator((TimeInterpolator)new OvershootInterpolator()).setDuration(600L).start();
        this.fadeOutBackground();
    }

    private void hideKeyboard() {
        View focusedView = this.getCurrentFocus();
        if (focusedView != null) {
            InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
        }
    }

    private void fadeOutBackground() {
        int colorTo = ContextCompat.getColor((Context)this, (int)17170445);
        int colorFrom = ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black);
        this.colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        this.colorAnimation.setDuration(300L);
        this.colorAnimation.setStartDelay(100L);
        this.colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator2) {
                IntercomMessengerActivity.this.background.setBackgroundColor(((Integer)animator2.getAnimatedValue()).intValue());
            }
        });
        this.colorAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.finish();
                IntercomMessengerActivity.this.overridePendingTransition(0, 0);
            }
        });
        this.colorAnimation.start();
    }

    @Override
    public void onToolbarCloseClicked() {
        this.metricStore.track(this.metricFactory.closedMessengerCloseButton());
        this.closeMessenger();
    }

    @Override
    public void onBackToInboxClicked() {
        if (this.hasLoadedFragment(InboxFragment.class.getName())) {
            this.onBackPressed();
        } else {
            this.trackMoveToConversationListMetric();
            this.displayFragment(this.inboxFragment, InboxFragment.class.getName(), false);
        }
    }

    private void showBackgroundColour() {
        this.background.setBackgroundResource(R.color.intercom_transparent_black);
    }

    private void hideBackgroundColor() {
        this.background.setBackgroundResource(R.color.intercom_full_transparent_full_black);
    }

    @Override
    public void setStatusBarColor() {
        StatusBarThemer.setStatusBarColor(this.getWindow());
    }

    public static Intent openInbox(Context context) {
        return new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, true);
    }

    public static Intent openComposer(Context context, String initialMessage) {
        Intent intent = new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, false);
        if (!TextUtils.isEmpty((CharSequence)initialMessage)) {
            intent.putExtra(PARCEL_INITIAL_MESSAGE, initialMessage);
        }
        return intent;
    }

    public static Intent openConversation(Context context, String conversationId, LastParticipatingAdmin lastParticipatingAdmin) {
        Intent intent = new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, false);
        if (!TextUtils.isEmpty((CharSequence)conversationId)) {
            intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        }
        if (!LastParticipatingAdmin.isNull(lastParticipatingAdmin)) {
            intent.putExtra(LAST_PARTICIPANT, (Parcelable)lastParticipatingAdmin);
        }
        return intent;
    }

    @Subscribe
    public void closeSdk(CloseMessengerEvent event) {
        this.finish();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.containerView.setY(0.0f);
        this.containerView.getLayoutParams().height = -1;
    }

    private boolean hasLoadedFragment(String fragmentTag) {
        return this.getSupportFragmentManager().findFragmentByTag(fragmentTag) != null;
    }
}

