/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.support.annotation.NonNull;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusEventPropagator;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.android.sdk.nexus.NexusLogger;
import io.intercom.android.sdk.nexus.NexusSocket;
import io.intercom.okhttp3.OkHttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NexusClient {
    private final List<NexusSocket> sockets = new ArrayList<NexusSocket>();
    private final NexusEventPropagator eventPropagator;
    private final OkHttpClient client;
    private ScheduledExecutorService backgroundTaskExecutor;
    private ScheduledFuture future;
    private long presenceInterval;

    public NexusClient() {
        this(new NexusEventPropagator());
    }

    NexusClient(NexusEventPropagator eventPropagator) {
        this.eventPropagator = eventPropagator;
        this.client = new OkHttpClient.Builder().readTimeout(130L, TimeUnit.SECONDS).writeTimeout(130L, TimeUnit.SECONDS).connectTimeout(20L, TimeUnit.SECONDS).build();
    }

    public void connect(NexusConfig config, boolean shouldSendPresence) {
        if (config.getEndpoints().isEmpty()) {
            NexusLogger.errorLog("No endpoints present");
            return;
        }
        if (this.backgroundTaskExecutor == null) {
            NexusThreadFactory threadFactory = new NexusThreadFactory();
            this.backgroundTaskExecutor = Executors.newScheduledThreadPool(config.getEndpoints().size() + 1, threadFactory);
        }
        for (String url : config.getEndpoints()) {
            NexusLogger.d("adding socket");
            this.sockets.add(new NexusSocket(url, config.getConnectionTimeout(), shouldSendPresence, this.backgroundTaskExecutor, this.client, this.eventPropagator));
        }
        this.presenceInterval = config.getPresenceHeartbeatInterval();
        if (shouldSendPresence) {
            this.schedulePresence();
        }
    }

    public synchronized void disconnect() {
        if (!this.sockets.isEmpty()) {
            for (NexusSocket nexusSocket : this.sockets) {
                NexusLogger.d("disconnecting socket");
                nexusSocket.disconnect();
            }
            this.sockets.clear();
            NexusLogger.d("client disconnected");
        }
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public synchronized void fire(NexusEvent event) {
        this.eventPropagator.cacheEvent(event);
        String data = event.toStringEncodedJsonObject();
        if (!data.isEmpty()) {
            for (NexusSocket nexusSocket : this.sockets) {
                nexusSocket.fire(data);
            }
        }
    }

    public synchronized void localUpdate(@NonNull NexusEvent event) {
        this.eventPropagator.notifyEvent(event);
    }

    public synchronized boolean isConnected() {
        for (NexusSocket socket : this.sockets) {
            if (!socket.isConnected()) continue;
            return true;
        }
        return false;
    }

    public void addEventListener(@NonNull NexusListener listener) {
        this.eventPropagator.addListener(listener);
    }

    public void removeEventListener(@NonNull NexusListener listener) {
        this.eventPropagator.removeListener(listener);
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        NexusLogger.setLoggingEnabled(loggingEnabled);
    }

    private void schedulePresence() {
        if (this.presenceInterval > 0L) {
            this.future = this.backgroundTaskExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    NexusClient.this.fire(NexusEvent.getUserPresenceEvent());
                    NexusClient.this.schedulePresence();
                }
            }, this.presenceInterval, TimeUnit.SECONDS);
        }
    }

    private static class NexusThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private int threadCount = 0;

        private NexusThreadFactory() {
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread thread = this.defaultFactory.newThread(r);
            ++this.threadCount;
            thread.setName("IntercomNexus-" + this.threadCount);
            return thread;
        }
    }
}

