/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.android.sdk.nexus.NexusLogger;
import io.intercom.okhttp3.OkHttpClient;
import io.intercom.okhttp3.Request;
import io.intercom.okhttp3.RequestBody;
import io.intercom.okhttp3.Response;
import io.intercom.okhttp3.ResponseBody;
import io.intercom.okhttp3.ws.WebSocket;
import io.intercom.okhttp3.ws.WebSocketCall;
import io.intercom.okhttp3.ws.WebSocketListener;
import io.intercom.okio.Buffer;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class NexusSocket
implements WebSocketListener {
    private static final int OK_CLIENT_DISCONNECT = 4000;
    private static final int N_TIMEOUT_DISCONNECT = 4001;
    private static final int MAX_RECONNECT_TIME = 256;
    private static final String HEADER = "?X-Nexus-Version=android.2.0.3";
    private final NexusListener eventNotifier;
    private final ScheduledExecutorService backgroundTaskExecutor;
    private final OkHttpClient client;
    private final String nexusUrl;
    private final long connectionTimeoutSeconds;
    private final boolean shouldSendPresence;
    private WebSocket socket = new ClosedSocket();
    private ScheduledFuture timeoutFuture;
    private Runnable timeoutRunnable = new Runnable(){

        @Override
        public void run() {
            NexusSocket.this.timedOut();
        }
    };
    private long lastReconnectAt = 0L;
    private int reconnectAttempts = 0;

    public NexusSocket(String nexusUrl, int connectionTimeoutSeconds, boolean shouldSendPresence, ScheduledExecutorService backgroundTaskExecutor, OkHttpClient client, NexusListener eventNotifier) {
        this.nexusUrl = nexusUrl;
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        this.shouldSendPresence = shouldSendPresence;
        this.eventNotifier = eventNotifier;
        this.client = client;
        this.backgroundTaskExecutor = backgroundTaskExecutor;
        this.connect(nexusUrl);
    }

    private void connect(String url) {
        NexusLogger.d("connecting to a socket...");
        this.socket = new ConnectingSocket();
        final Request request = new Request.Builder().url(url + HEADER).build();
        this.backgroundTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                WebSocketCall.create(NexusSocket.this.client, request).enqueue(NexusSocket.this);
            }
        });
        this.timeoutFuture = this.backgroundTaskExecutor.schedule(this.timeoutRunnable, this.connectionTimeoutSeconds, TimeUnit.SECONDS);
    }

    public void fire(final String data) {
        if (!data.isEmpty()) {
            this.backgroundTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        NexusLogger.v("firing: " + data);
                        NexusSocket.this.socket.sendMessage(RequestBody.create(WebSocket.TEXT, data));
                    }
                    catch (IOException | IllegalStateException e) {
                        NexusLogger.errorLog("fire: " + data, e);
                    }
                }
            });
        }
    }

    public void disconnect() {
        this.disconnect(4000);
    }

    public boolean isConnected() {
        return !(this.socket instanceof ClosedSocket);
    }

    private void disconnect(final int code) {
        this.backgroundTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    NexusSocket.this.socket.close(code, "Goodbye, world!");
                }
                catch (IOException e) {
                    NexusLogger.errorLog("disconnect: failed " + e.getMessage());
                    NexusLogger.errorLog("disconnect: failed", e);
                }
                catch (IllegalStateException ex) {
                    NexusLogger.errorLog("disconnect: socket already closed", ex);
                }
            }
        });
    }

    private void timedOut() {
        if (this.socket == null) {
            this.connect(this.nexusUrl);
        } else {
            this.disconnect(4001);
        }
        this.eventNotifier.onConnectFailed();
    }

    private void resetTimeout() {
        this.timeoutFuture.cancel(true);
        this.timeoutFuture = this.backgroundTaskExecutor.schedule(this.timeoutRunnable, this.connectionTimeoutSeconds, TimeUnit.SECONDS);
    }

    private void scheduleReconnect() {
        this.modifyReconnectAttempts();
        this.backgroundTaskExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                NexusSocket.this.connect(NexusSocket.this.nexusUrl);
            }
        }, NexusSocket.calculateReconnectTimerInSeconds(this.reconnectAttempts), TimeUnit.SECONDS);
    }

    private void modifyReconnectAttempts() {
        long maxReconnectTimeIncludingJitter;
        long millisSinceLastAttempt = System.currentTimeMillis() - this.lastReconnectAt;
        if (millisSinceLastAttempt > (maxReconnectTimeIncludingJitter = TimeUnit.SECONDS.toMillis(256L) * 2L)) {
            NexusLogger.d("resetting reconnection attempts");
            this.reconnectAttempts = 1;
        } else {
            NexusLogger.d("incrementing reconnection attempts");
            ++this.reconnectAttempts;
        }
        this.lastReconnectAt = System.currentTimeMillis();
    }

    @Override
    public void onOpen(WebSocket webSocket, Response response) {
        NexusLogger.d("onOpen: " + response.message());
        this.socket = webSocket;
        this.resetTimeout();
        if (this.shouldSendPresence) {
            this.fire(NexusEvent.getUserPresenceEvent().toStringEncodedJsonObject());
        }
        this.eventNotifier.onConnect();
    }

    @Override
    public void onMessage(ResponseBody message) throws IOException {
        String s;
        this.resetTimeout();
        if (message.contentType() == WebSocket.TEXT && !(s = message.string()).isEmpty() && !s.equals(" ")) {
            try {
                JSONObject jObject = new JSONObject(s);
                String eventName = jObject.optString("eventName");
                if (!eventName.isEmpty() && !eventName.equals("ACK")) {
                    NexusLogger.v("onMessage TEXT: " + s);
                    NexusEvent event = new NexusEvent(jObject);
                    this.eventNotifier.notifyEvent(event);
                } else {
                    NexusLogger.d("onMessage ACK: " + s);
                }
            }
            catch (JSONException e) {
                NexusLogger.errorLog("onMessage: json parse exception for message: " + s);
                NexusLogger.errorLog("onMessage: json parse exception", (Exception)((Object)e));
            }
        }
        message.close();
    }

    @Override
    public void onPong(Buffer payload) {
        payload.close();
    }

    @Override
    public void onClose(int code, String reason) {
        switch (code) {
            case 4000: {
                this.shutdown();
                break;
            }
            default: {
                this.scheduleReconnect();
            }
        }
        NexusLogger.d("onClose code: " + code + " reason: " + reason);
    }

    @Override
    public void onFailure(IOException e, Response response) {
        if (NexusSocket.shouldReconnectFromFailure(e.getMessage())) {
            this.scheduleReconnect();
        } else {
            this.shutdown();
        }
        NexusLogger.errorLog("onFailure: " + e.getMessage(), e);
        NexusLogger.errorLog("onFailure: " + response, e);
        this.eventNotifier.onConnectFailed();
    }

    private void shutdown() {
        this.socket = new ClosedSocket();
        this.timeoutFuture.cancel(true);
    }

    public static long calculateReconnectTimerInSeconds(int reconnectAttempts) {
        int minimumBackoffSeconds = (int)Math.min(Math.pow(2.0, reconnectAttempts), 256.0);
        int jitter = new Random().nextInt(minimumBackoffSeconds + 1);
        long seconds = minimumBackoffSeconds + jitter;
        NexusLogger.d("Scheduling reconnect in: " + seconds + " for attempt: " + reconnectAttempts);
        return seconds;
    }

    static boolean shouldReconnectFromFailure(String exception) {
        String okhttpOpeningError = "Expected HTTP 101 response but was";
        if (exception != null) {
            if (exception.equals("closed")) {
                return false;
            }
            if (exception.startsWith(okhttpOpeningError)) {
                return exception.substring(okhttpOpeningError.length()).startsWith(" '5");
            }
        }
        return true;
    }

    private class ClosedSocket
    extends DummySocket {
        private ClosedSocket() {
        }
    }

    private class ConnectingSocket
    extends DummySocket {
        private ConnectingSocket() {
        }
    }

    private static class DummySocket
    implements WebSocket {
        private DummySocket() {
        }

        @Override
        public void sendMessage(RequestBody message) throws IOException {
        }

        @Override
        public void sendPing(Buffer payload) throws IOException {
        }

        @Override
        public void close(int code, String reason) throws IOException {
        }
    }
}

