/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.StateListDrawable;
import io.intercom.android.sdk.Injector;

public class ButtonSelector
extends StateListDrawable {
    private final int color = Injector.get().getAppIdentity().getAppConfig().getBaseColor();

    public ButtonSelector(Context c, int imageResource) {
        this.addState(new int[]{16842910}, c.getResources().getDrawable(imageResource));
        this.addState(new int[]{16842908}, c.getResources().getDrawable(imageResource));
        this.addState(new int[]{16842919}, c.getResources().getDrawable(imageResource));
    }

    protected boolean onStateChange(int[] states) {
        boolean isClicked = false;
        for (int state : states) {
            if (state != 16842919 && state != 16842908) continue;
            isClicked = true;
        }
        if (isClicked) {
            this.setColorFilter(ButtonSelector.darken(this.color, 0.9), PorterDuff.Mode.SRC);
        } else {
            this.setColorFilter(this.color, PorterDuff.Mode.SRC);
        }
        return super.onStateChange(states);
    }

    private static int darken(int color2, double fraction) {
        int red = (int)((double)Color.red((int)color2) * fraction);
        int green = (int)((double)Color.green((int)color2) * fraction);
        int blue = (int)((double)Color.blue((int)color2) * fraction);
        return Color.argb((int)255, (int)red, (int)green, (int)blue);
    }
}

