/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.lightbox;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.ViewGroup;
import android.widget.ImageView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.lightbox.LightBoxImageView;
import io.intercom.android.sdk.lightbox.LightBoxListener;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;

public class LightBoxActivity
extends AppCompatActivity
implements LightBoxListener {
    private static final String EXTRA_IMAGE_URL = "extra_image_url";
    private static final String EXTRA_ACTIVITY_FULLSCREEN = "extra_activity_fullscreen";
    private static final int ANIMATION_TIME_MS = 300;
    public static final String TRANSITION_KEY = "lightbox_image";
    private LightBoxImageView fullImage;
    private String imageUrl = "";
    private ViewGroup rootView;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle data = this.getIntent().getExtras();
        if (data != null) {
            this.imageUrl = data.getString(EXTRA_IMAGE_URL, "");
            if (data.getBoolean(EXTRA_ACTIVITY_FULLSCREEN, false)) {
                this.requestWindowFeature(1);
                this.getWindow().setFlags(1024, 1024);
            }
        }
        this.setContentView(R.layout.intercom_activity_lightbox);
        this.rootView = (ViewGroup)this.findViewById(R.id.root_view);
        this.fullImage = (LightBoxImageView)this.findViewById(R.id.full_image);
        if (Build.VERSION.SDK_INT >= 21) {
            this.fullImage.setTransitionName(TRANSITION_KEY);
        }
        Glide.with((FragmentActivity)this).load(this.imageUrl).bitmapTransform(new Transformation[]{new RoundedCornersTransform((Context)this, this.getResources().getDimensionPixelSize(R.dimen.intercomsdk_image_rounded_corners))}).error(R.drawable.intercom_error).dontAnimate().diskCacheStrategy(ImageUtils.getDiskCacheStrategy(this.imageUrl)).into((ImageView)this.fullImage);
        this.fullImage.setLightBoxListener(this);
        this.fadeIn();
    }

    private void fadeIn() {
        int colorFrom = ContextCompat.getColor((Context)this, (int)R.color.intercom_full_transparent_full_black);
        int colorTo = ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black_lightbox);
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration(300L);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator2) {
                LightBoxActivity.this.rootView.setBackgroundColor(((Integer)animator2.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.start();
    }

    private void fadeOut() {
        int colorFrom = ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black_lightbox);
        int colorTo = ContextCompat.getColor((Context)this, (int)R.color.intercom_full_transparent_full_black);
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration(300L);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator2) {
                LightBoxActivity.this.rootView.setBackgroundColor(((Integer)animator2.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
            }
        });
        colorAnimation.start();
    }

    public static Intent imageIntent(Context context, String url, boolean fullScreen) {
        return new Intent(context, LightBoxActivity.class).setFlags(0x10000000).putExtra(EXTRA_IMAGE_URL, url).putExtra(EXTRA_ACTIVITY_FULLSCREEN, fullScreen);
    }

    public void onBackPressed() {
        this.closeLightBox();
    }

    @Override
    public void closeLightBox() {
        this.fadeOut();
        this.supportFinishAfterTransition();
    }
}

