/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.text.Html;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.OrderedListBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.UnorderedListBlock;
import io.intercom.android.sdk.spans.OrderedListSpan;
import io.intercom.android.sdk.spans.UnorderedListSpan;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;
import java.util.List;

class ListBlock
implements OrderedListBlock,
UnorderedListBlock {
    private static final int LARGE_TEXT_SIZE_SP = 16;
    private static final int SMALL_TEXT_SIZE_SP = 14;
    private final StyleType style;
    private final Context context;

    public ListBlock(Context context, StyleType style) {
        this.context = context;
        this.style = style;
    }

    public View addOrderedList(List<String> items, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview = this.getListStyledTextView();
        int lineIndent = (int)this.context.getResources().getDimension(R.dimen.intercomsdk_list_indentation);
        CharSequence chars = "";
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            String item = items.get(i);
            if (item.isEmpty()) continue;
            String delimiter = i < size - 1 ? "<br />" : "";
            Spanned source = Html.fromHtml((String)(item + delimiter));
            SpannableString spannableString = new SpannableString((CharSequence)source);
            spannableString.setSpan((Object)new OrderedListSpan(lineIndent, i + 1 + "."), 0, source.length(), 0);
            chars = TextUtils.concat((CharSequence[])new CharSequence[]{chars, spannableString});
        }
        textview.setText(chars);
        BlockUtils.setLayoutMarginsAndGravity((View)textview, 3, isLastObject);
        return textview;
    }

    public View addUnorderedList(List<String> items, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview = this.getListStyledTextView();
        int lineIndent = (int)this.context.getResources().getDimension(R.dimen.intercomsdk_list_indentation);
        CharSequence chars = "";
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            String item = items.get(i);
            if (item.isEmpty()) continue;
            String delimiter = i < size - 1 ? "<br />" : "";
            Spanned source = Html.fromHtml((String)(item + delimiter));
            SpannableString spannableString = new SpannableString((CharSequence)source);
            spannableString.setSpan((Object)new UnorderedListSpan(lineIndent, this.context), 0, source.length(), 0);
            chars = TextUtils.concat((CharSequence[])new CharSequence[]{chars, spannableString});
        }
        textview.setText(chars);
        BlockUtils.setLayoutMarginsAndGravity((View)textview, 3, isLastObject);
        return textview;
    }

    private TextView getListStyledTextView() {
        TextView textview = new TextView(this.context);
        textview.setLinkTextColor(Injector.get().getAppIdentity().getAppConfig().getBaseColor());
        BlockUtils.createLayoutParams((View)textview, -2, -2);
        BlockUtils.setMarginLeft((View)textview, 4);
        switch (this.style) {
            case ADMIN: {
                int color2 = ContextCompat.getColor((Context)this.context, (int)R.color.intercom_text_light_black);
                this.styleAsChatList(textview, 14, color2);
                textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                break;
            }
            case NOTE: 
            case CONTAINER_CARD: {
                int color3 = ContextCompat.getColor((Context)this.context, (int)R.color.intercom_grey_700);
                this.styleAsAnnouncementList(textview, 16, color3);
                textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                break;
            }
            case POST: {
                int color4 = ContextCompat.getColor((Context)this.context, (int)R.color.intercom_white);
                this.styleAsAnnouncementList(textview, 16, color4);
                textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
                break;
            }
            case CHAT_FULL: {
                int color5 = ContextCompat.getColor((Context)this.context, (int)R.color.intercom_text_light_black);
                this.styleAsChatList(textview, 14, color5);
                break;
            }
            default: {
                int color6 = ContextCompat.getColor((Context)this.context, (int)R.color.intercom_white);
                this.styleAsChatList(textview, 14, color6);
                textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
            }
        }
        return textview;
    }

    private void styleAsChatList(TextView textview, int textSizeSp, int colour) {
        textview.setTextSize(2, (float)textSizeSp);
        textview.setTextColor(colour);
        BlockUtils.setDefaultMarginBottom((View)textview);
        BlockUtils.setSmallLineSpacing(textview);
    }

    private void styleAsAnnouncementList(TextView textview, int textSizeSp, int colour) {
        textview.setTextSize(2, (float)textSizeSp);
        textview.setTextColor(colour);
        BlockUtils.setMarginBottom((View)textview, 16);
        BlockUtils.setLargeLineSpacing(textview);
    }
}

