/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.views.LockableScrollView;
import io.intercom.android.sdk.views.holder.ConversationListener;
import io.intercom.android.sdk.views.holder.ConversationViewHolder;

public class ContainerCardViewHolder
extends ConversationViewHolder {
    private final LockableScrollView lockableScrollView;
    @Nullable
    private ImageView arrowExpander;
    private final int viewType;
    private final View fade;
    private final TextView author;
    private final TextView appName;
    private final String fromAppName;

    public ContainerCardViewHolder(View itemView, int viewType, ConversationListener conversationListener, @Nullable ClipboardManager clipboardManager, Context context, boolean allowExpansionArrow) {
        super(itemView, conversationListener, clipboardManager, context);
        AppConfig appConfig = Injector.get().getIdentityStore().getAppConfig();
        this.fromAppName = String.format(context.getResources().getString(R.string.intercom_from_company), appConfig.getName());
        this.viewType = viewType;
        this.author = (TextView)itemView.findViewById(R.id.intercom_container_card_author);
        this.appName = (TextView)itemView.findViewById(R.id.intercom_container_card_app_name);
        this.fade = itemView.findViewById(R.id.intercom_container_fade_view);
        ProgressBar progressBar = (ProgressBar)itemView.findViewById(R.id.progressBar);
        progressBar.getIndeterminateDrawable().setColorFilter(appConfig.getBaseColor(), PorterDuff.Mode.SRC_IN);
        this.lockableScrollView = (LockableScrollView)itemView.findViewById(R.id.cell_content);
        this.lockableScrollView.setScrollingEnabled(false);
        if (viewType == 3) {
            if (allowExpansionArrow) {
                this.arrowExpander = (ImageView)itemView.findViewById(R.id.expand_arrow);
            }
            this.lockableScrollView.setExpanded(!allowExpansionArrow);
        } else {
            this.lockableScrollView.setExpanded(false);
        }
        final View blocksView = itemView.findViewById(R.id.cellLayout);
        blocksView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                blocksView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                ContainerCardViewHolder.this.setupViews();
                return false;
            }
        });
    }

    @Override
    public void bind(Part part) {
        LinearLayout blocks = this.setUpHolderBlocks(part, this.cellLayout, this.bubble, this.infoIcon);
        this.showAvatar(part.getParticipant(), this.networkAvatar);
        this.author.setText((CharSequence)part.getParticipant().getForename());
        this.appName.setText((CharSequence)this.fromAppName);
        this.checkForEntranceAnimation(this.viewType, part, this.networkAvatar, this.cellLayout, blocks);
    }

    public void onClick(View v) {
        this.conversationListener.onContainerCardClicked(this.getAdapterPosition(), this);
    }

    public void toggleExpanded() {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (ContainerCardViewHolder.this.arrowExpander != null && ContainerCardViewHolder.this.arrowExpander.getVisibility() == 0) {
                    ContainerCardViewHolder.this.lockableScrollView.toggleExpanded();
                    ContainerCardViewHolder.this.setupViews();
                }
            }
        });
    }

    void setupViews() {
        if (this.viewType == 2) {
            this.layoutForPost();
        } else if (this.arrowExpander == null) {
            this.layoutForExpandedNoteWithoutArrow();
        } else if (this.lockableScrollView.isExpanded()) {
            this.layoutForExpandedNoteWithArrow();
        } else {
            this.layoutForCollapsedNoteWithArrow();
        }
    }

    void layoutForPost() {
        if (this.arrowExpander != null) {
            this.arrowExpander.setVisibility(8);
        }
        this.fade.setVisibility(this.contentIsOverflowing() ? 0 : 4);
    }

    private boolean contentIsOverflowing() {
        int scrollHeight;
        int childHeight = this.lockableScrollView.getChildAt(0).getMeasuredHeight();
        return childHeight > (scrollHeight = this.lockableScrollView.getMaxHeight());
    }

    void layoutForExpandedNoteWithoutArrow() {
        if (this.arrowExpander != null) {
            this.arrowExpander.setVisibility(8);
        }
        this.fade.setVisibility(4);
    }

    void layoutForExpandedNoteWithArrow() {
        if (this.arrowExpander != null) {
            this.arrowExpander.setVisibility(this.contentIsOverflowing() ? 0 : 8);
            this.arrowExpander.setScaleY(-1.0f);
        }
        this.fade.setVisibility(4);
    }

    void layoutForCollapsedNoteWithArrow() {
        if (this.arrowExpander != null) {
            this.arrowExpander.setVisibility(this.contentIsOverflowing() ? 0 : 8);
            this.arrowExpander.setScaleY(1.0f);
        }
        this.fade.setVisibility(this.contentIsOverflowing() ? 0 : 4);
    }

    void runOnMainThread(Runnable action) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            action.run();
        } else {
            this.lockableScrollView.post(action);
        }
    }
}

