/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.decoration;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.models.Part;
import java.util.List;

public class ConversationItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int SPACING = 24;
    private static final int DIVIDER_TOP_SPACING = 16;
    private static final int DIVIDER_BOTTOM_SPACING = 12;
    private static final int CONCAT_SPACING = 4;
    private final List<Part> parts;
    private final int spacing;
    private final int concatSpacing;
    private final int headerTopSpacing;
    private final int headerBottomSpacing;

    public ConversationItemDecoration(Context context, List<Part> parts) {
        this.parts = parts;
        this.spacing = ScreenUtils.convertDpToPixel((float)24.0f, (Context)context);
        this.concatSpacing = ScreenUtils.convertDpToPixel((float)4.0f, (Context)context);
        this.headerTopSpacing = ScreenUtils.convertDpToPixel((float)16.0f, (Context)context);
        this.headerBottomSpacing = ScreenUtils.convertDpToPixel((float)12.0f, (Context)context);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        int position = recyclerView.getChildLayoutPosition(view);
        if (position != -1 && position < this.parts.size()) {
            Part currentPart = this.parts.get(position);
            boolean shouldConcatenate = this.shouldConcatenate(currentPart, recyclerView, position);
            if (shouldConcatenate) {
                outRect.set(0, 0, 0, this.concatSpacing);
            } else if (position == 0) {
                outRect.set(0, this.headerTopSpacing, 0, this.headerBottomSpacing);
            } else {
                outRect.set(0, 0, 0, this.spacing);
            }
        }
    }

    @VisibleForTesting
    boolean shouldConcatenate(Part conversationPart, RecyclerView recyclerView, int position) {
        RecyclerView.Adapter adapter = recyclerView.getAdapter();
        if (position + 1 < adapter.getItemCount()) {
            Part nextPart = this.parts.get(position + 1);
            return Part.shouldConcatenate(conversationPart, nextPart);
        }
        return false;
    }
}

