/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.preview.PreviewCallbacks;
import io.intercom.android.sdk.preview.Snippet;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringListener;
import io.intercom.com.facebook.rebound.SpringSystem;
import io.intercom.com.facebook.rebound.SpringUtil;

public class ChatSnippet
extends Snippet {
    private static final int MAX_LINES_FOR_CHAT = 2;
    private static final int ANIMATION_DURATION = 170;
    private static final int GROWTH_WIDTH = 355;

    public ChatSnippet(Context context, Conversation conversation, int position, SpringSystem springSystem, int screenHeight, PreviewCallbacks previewCallbacks) {
        super(context, conversation, position, springSystem, screenHeight, previewCallbacks);
    }

    @Override
    public void update(Conversation conversation, Runnable updateEndAction) {
        this.conversation = conversation;
        View text = this.notificationRoot.findViewById(R.id.chathead_text_body);
        View textContainer = this.notificationRoot.findViewById(R.id.chathead_text_container);
        textContainer.setPivotX(0.0f);
        this.performReplyPulse(textContainer, text, updateEndAction);
    }

    @Override
    protected void pulseUpdate() {
        this.displayChatHead((View)this.notificationRoot, this.conversation);
    }

    private void displayChatHead(View root, Conversation conversation) {
        Context context = root.getContext();
        View chatRootView = root.findViewById(R.id.chathead_root);
        ImageView avatarView = (ImageView)chatRootView.findViewById(R.id.chathead_avatar);
        TextView headerTextView = (TextView)chatRootView.findViewById(R.id.chathead_text_header);
        final TextView bodyTextView = (TextView)chatRootView.findViewById(R.id.chathead_text_body);
        headerTextView.setTextColor(Injector.get().getIdentityStore().getAppConfig().getBaseColor());
        Part lastPart = conversation.getLastPart();
        final boolean isSummary = lastPart.getDeliveryOption() == Part.DeliveryOption.SUMMARY;
        FontUtils.setTypeface(context, headerTextView, "intercom_roboto_medium.ttf");
        AvatarUtils.createAvatar(conversation.getLastAdmin().getAvatar(), avatarView, context);
        headerTextView.setText((CharSequence)this.getHeaderText(headerTextView.getContext()));
        if (!lastPart.getSummary().isEmpty()) {
            bodyTextView.setText((CharSequence)lastPart.getSummary());
        } else {
            bodyTextView.setText(R.string.intercomsdk_image_attached);
        }
        if (isSummary) {
            bodyTextView.setMaxLines(2);
        }
        bodyTextView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (!isSummary) {
                    int maxLines = (int)Math.ceil((double)bodyTextView.getHeight() / (double)bodyTextView.getLineHeight());
                    bodyTextView.setMaxLines(maxLines);
                }
                ViewUtils.removeGlobalLayoutListener((View)bodyTextView, this);
            }
        });
        IntercomLogger.internal("preview", "displayed preview");
    }

    private void performEntranceAnimation() {
        View avatarView = this.notificationRoot.findViewById(R.id.chat_avatar_container);
        final LinearLayout textContainerView = (LinearLayout)this.notificationRoot.findViewById(R.id.chathead_text_container);
        textContainerView.setVisibility(4);
        PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)avatarView, (PropertyValuesHolder[])new PropertyValuesHolder[]{alpha}).setDuration(400L);
        objectAnimator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                ChatSnippet.this.animateTextContainer(textContainerView);
            }
        });
        objectAnimator.start();
    }

    private void animateTextContainer(final LinearLayout textContainerView) {
        final int startValue = (int)textContainerView.getX() - 150;
        final int endValue = (int)textContainerView.getX();
        float propertiesStartValue = 0.8f;
        textContainerView.setScaleX(0.8f);
        textContainerView.setScaleY(0.8f);
        textContainerView.setAlpha(0.8f);
        textContainerView.setX((float)startValue);
        this.spring.removeAllListeners();
        this.spring.setCurrentValue((double)startValue);
        this.spring.setEndValue((double)endValue);
        this.spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                float mappedVal = (float)SpringUtil.mapValueFromRangeToRange((double)spring.getCurrentValue(), (double)startValue, (double)endValue, (double)0.8f, (double)1.0);
                textContainerView.setScaleX(mappedVal);
                textContainerView.setScaleY(mappedVal);
                textContainerView.setX((float)spring.getCurrentValue());
                textContainerView.setAlpha(mappedVal);
            }

            public void onSpringActivate(Spring spring) {
                textContainerView.setVisibility(0);
            }

            public void onSpringAtRest(Spring spring) {
                ChatSnippet.this.beginListeningForTouchEvents();
            }
        });
    }

    @Override
    protected void onPreviewPressed(View view) {
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f, 0.9f});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f, 0.9f});
        PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f, 0.9f});
        ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY, alpha}).setDuration(50L).start();
    }

    @Override
    protected void onPreviewReleased(View view) {
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.9f, 1.0f});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.9f, 1.0f});
        PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{0.9f, 1.0f});
        ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY, alpha}).setDuration(50L).start();
    }

    @Override
    public void display(ViewGroup root, LayoutInflater inflater, boolean withFullAnimation) {
        this.setupView(root, inflater);
        this.displayChatHead((View)this.notificationRoot, this.conversation);
        if (withFullAnimation) {
            this.performEntranceAnimation();
        } else {
            this.notificationRoot.setVisibility(0);
            this.beginListeningForTouchEvents();
        }
    }

    @Override
    public void moveBackward(ViewGroup rootView, SimpleAnimatorListener animationListener) {
        ++this.position;
        this.animateToPosition(rootView.getContext());
        this.expandChat(rootView, animationListener);
    }

    private void setupView(ViewGroup root, LayoutInflater inflater) {
        if (this.notificationRoot == null) {
            this.notificationRoot = (ViewGroup)inflater.inflate(R.layout.intercom_preview_chathead, root, false);
        }
        if (!this.isAttached()) {
            root.addView((View)this.notificationRoot, 0);
        }
    }

    private void expandChat(ViewGroup rootView, SimpleAnimatorListener animatorListener) {
        ViewGroup bubble = (ViewGroup)rootView.findViewById(R.id.chathead_text_container);
        TextView headerTextView = (TextView)rootView.findViewById(R.id.chathead_text_header);
        TextView bodyTextView = (TextView)rootView.findViewById(R.id.chathead_text_body);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)bubble.getLayoutParams();
        View avatarView = rootView.findViewById(R.id.chat_avatar_container);
        float transx = avatarView.getTranslationX();
        float transy = avatarView.getTranslationY();
        ObjectAnimator.ofPropertyValuesHolder((Object)avatarView, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f, 0.8f}), PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{transx, transx + 100.0f}), PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{transy, transy - 40.0f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f, 0.8f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f, 0.8f})}).setDuration(170L).start();
        ObjectAnimator.ofFloat((Object)headerTextView, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(170L).start();
        ObjectAnimator.ofFloat((Object)bodyTextView, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(170L).start();
        this.getWidthAnimator(bubble, animatorListener).start();
        this.getWidthAnimator(this.notificationRoot).start();
        this.getMarginAnimator(bubble, layoutParams).start();
    }

    private Animator getMarginAnimator(final ViewGroup bubble, FrameLayout.LayoutParams layoutParams) {
        int leftMargin = layoutParams.leftMargin;
        ValueAnimator animator2 = ValueAnimator.ofInt((int[])new int[]{leftMargin, 0});
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int val = (Integer)animation.getAnimatedValue();
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)bubble.getLayoutParams();
                layoutParams.leftMargin = val;
                bubble.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        });
        animator2.setDuration(170L);
        return animator2;
    }

    private Animator getWidthAnimator(ViewGroup bubble, final Animator.AnimatorListener animatorListener) {
        final int diff = Math.abs(bubble.getMeasuredWidth() - ScreenUtils.convertDpToPixel((float)355.0f, (Context)bubble.getContext()));
        ValueAnimator animator2 = this.getWidthAnimator(bubble);
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            boolean hasSentUpdate = false;

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                int percentage = val / diff * 100;
                if (percentage > 80 && !this.hasSentUpdate) {
                    this.hasSentUpdate = true;
                    animatorListener.onAnimationEnd(null);
                }
            }
        });
        return animator2;
    }

    private ValueAnimator getWidthAnimator(final ViewGroup view) {
        int from = view.getMeasuredWidth();
        int to = ScreenUtils.convertDpToPixel((float)355.0f, (Context)view.getContext());
        ValueAnimator animator2 = ValueAnimator.ofInt((int[])new int[]{from, to});
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
                layoutParams.width = val;
                view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        });
        animator2.setDuration(170L);
        return animator2;
    }
}

