/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.AppTypeDetector;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.com.google.gson.Gson;
import io.intercom.okio.BufferedSink;
import io.intercom.okio.BufferedSource;
import io.intercom.okio.Okio;
import io.intercom.okio.Sink;
import io.intercom.okio.Source;
import io.intercom.retrofit2.Call;
import io.intercom.retrofit2.Callback;
import io.intercom.retrofit2.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class MetricsStore {
    private static final Executor IO_EXECUTOR = Executors.newSingleThreadExecutor();
    private static final String METRICS_DISK_CACHE = "intercomMetricsDiskCache";
    private static final String DELIMITER = "~";
    @VisibleForTesting
    final List<MetricObject> metrics = new ArrayList<MetricObject>();
    private final Gson gson = new Gson();
    private final Executor ioExecutor;
    private final Context context;
    private final Api api;
    private final String installerPackageName;
    private final boolean isDebugBuild;

    public MetricsStore(Context context, Api api) {
        this(context, api, IO_EXECUTOR);
    }

    @VisibleForTesting
    MetricsStore(Context context, Api api, Executor ioExecutor) {
        this.context = context;
        this.api = api;
        this.ioExecutor = ioExecutor;
        this.isDebugBuild = AppTypeDetector.isDebugBuild(context);
        this.installerPackageName = AppTypeDetector.getInstallerPackageName(context);
    }

    public void track(MetricObject metric) {
        this.metrics.add(metric.addInstallerPackageName(this.installerPackageName).addIsDebugBuild(this.isDebugBuild));
        this.persistMetricToDiskOnWorkerThread(metric);
        IntercomLogger.internal("metrics", String.format("tracked %s", metric));
    }

    public void loadCachedMetrics() {
        this.readMetricsFromDiskOnWorkerThread();
    }

    public void sendMetrics() {
        if (!this.metrics.isEmpty()) {
            final ArrayList<MetricObject> sentMetrics = new ArrayList<MetricObject>(this.metrics);
            this.api.sendMetrics(sentMetrics, new Callback<Void>(){

                public void onResponse(Call<Void> call, Response<Void> response) {
                    if (response.isSuccessful()) {
                        MetricsStore.this.cleanUpMetrics(sentMetrics);
                    }
                }

                public void onFailure(Call<Void> call, Throwable t) {
                }
            });
        }
    }

    @VisibleForTesting
    void cleanUpMetrics(List<MetricObject> sentMetrics) {
        this.metrics.removeAll(sentMetrics);
        this.ioExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MetricsStore.this.context.deleteFile(MetricsStore.METRICS_DISK_CACHE);
            }
        });
        if (!this.metrics.isEmpty()) {
            for (MetricObject o : this.metrics) {
                this.persistMetricToDiskOnWorkerThread(o);
            }
        }
    }

    @VisibleForTesting
    void persistMetricToDiskOnWorkerThread(final MetricObject metricObject) {
        this.ioExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MetricsStore.this.persistMetricToDisk(metricObject);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void persistMetricToDisk(MetricObject metricObject) throws IOException {
        try (BufferedSink bufferedSink = null;){
            bufferedSink = Okio.buffer((Sink)Okio.sink((OutputStream)this.context.openFileOutput(METRICS_DISK_CACHE, 32768)));
            String jsonString = this.gson.toJson((Object)metricObject) + DELIMITER;
            bufferedSink.writeUtf8(jsonString);
            bufferedSink.flush();
        }
    }

    @VisibleForTesting
    void readMetricsFromDiskOnWorkerThread() {
        this.ioExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MetricsStore.this.readMetricsFromDisk();
                    MetricsStore.this.sendMetrics();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @WorkerThread
    private void readMetricsFromDisk() throws IOException {
        String[] objectsAsJson;
        String file;
        try (BufferedSource bufferedSource = null;){
            bufferedSource = Okio.buffer((Source)Okio.source((InputStream)this.context.openFileInput(METRICS_DISK_CACHE)));
            file = bufferedSource.readUtf8();
        }
        for (String jsonString : objectsAsJson = file.split(DELIMITER)) {
            this.metrics.add((MetricObject)this.gson.fromJson(jsonString, MetricObject.class));
        }
    }
}

