/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import io.intercom.android.sdk.models.Conversation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class ConversationsHolder
extends ArrayList<Conversation> {
    protected void syncInbox(List<Conversation> response, RecyclerView.Adapter adapter, LinearLayoutManager layoutManager) {
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        HashSet<String> seenIds = new HashSet<String>(response.size());
        for (Conversation conversation : response) {
            seenIds.add(conversation.getId());
            result.add(conversation);
        }
        for (Conversation conversation : this) {
            if (seenIds.contains(conversation.getId())) continue;
            result.add(conversation);
        }
        Collections.sort(result, new Comparator<Conversation>(){

            @Override
            public int compare(Conversation lhs, Conversation rhs) {
                return (int)(rhs.getLastPart().getCreatedAt() - lhs.getLastPart().getCreatedAt());
            }
        });
        this.clear();
        this.addAll(result);
        adapter.notifyDataSetChanged();
        if (layoutManager.findFirstCompletelyVisibleItemPosition() == 0) {
            layoutManager.scrollToPosition(0);
        }
    }

    @Nullable
    public Conversation getLastConversation() {
        if (this.isEmpty()) {
            return null;
        }
        return (Conversation)this.get(this.size() - 1);
    }
}

