/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Config;

public class AppIdentity {
    private static final String PREFS_API_KEY = "ApiKey";
    private static final String PREFS_APP_ID = "AppId";
    private final SharedPreferences prefs;
    private final AppConfig appConfig;
    private String apiKey;
    private String appId;

    public AppIdentity(Context context) {
        this.prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        this.apiKey = this.prefs.getString(PREFS_API_KEY, "");
        this.appId = this.prefs.getString(PREFS_APP_ID, "");
        this.appConfig = new AppConfig(context);
    }

    protected void update(String apiKey, String appId) {
        this.apiKey = apiKey;
        this.appId = appId;
        this.prefs.edit().putString(PREFS_API_KEY, apiKey).putString(PREFS_APP_ID, appId).apply();
    }

    protected void updateAppConfig(Config config) {
        this.appConfig.update(config);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getAppId() {
        return this.appId;
    }

    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    protected boolean appIdentityExists() {
        return !this.apiKey.isEmpty() && !this.appId.isEmpty();
    }

    @SuppressLint(value={"CommitPrefEdits"})
    protected void clear() {
        this.prefs.edit().clear().commit();
        this.apiKey = "";
        this.appId = "";
    }
}

