/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.NexusWrapper;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.TeamPresenceProvider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.attachments.AttachmentActivity;
import io.intercom.android.sdk.attachments.AttachmentData;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.Blocks;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.blocks.function.TimeStampGroup;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.conversation.ComposerInputView;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.conversation.RecyclerConversationAdapter;
import io.intercom.android.sdk.conversation.SpoolWrapper;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.conversation.events.AdminTypingEndedEvent;
import io.intercom.android.sdk.conversation.events.CancelAdminTypingEvent;
import io.intercom.android.sdk.conversation.events.SendingEvent;
import io.intercom.android.sdk.fragments.IntercomSupportFragment;
import io.intercom.android.sdk.identity.IdentityStore;
import io.intercom.android.sdk.imageloader.LongTermImageLoader;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.UploadEvent;
import io.intercom.android.sdk.models.events.failure.ConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.ReplyFailedEvent;
import io.intercom.android.sdk.models.events.failure.UploadFailedEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.models.events.realtime.UserContentSeenByAdminEvent;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.NetworkConnectivityListener;
import io.intercom.android.sdk.utilities.NetworkState;
import io.intercom.android.sdk.utilities.TimeUtils;
import io.intercom.android.sdk.views.AdminIsTypingView;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.ProfileCoordinator;
import io.intercom.android.sdk.views.decoration.ConversationItemDecoration;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.Subscribe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

@TargetApi(value=15)
public class ConversationFragment
extends IntercomSupportFragment
implements RecyclerConversationAdapter.PartClickedListener {
    private static final String ARG_IS_READ = "intercomsdk-isRead";
    private static final String ARG_CONVERSATION_ID = "conversationId";
    private static final String LAST_PARTICIPANT = "last_participant";
    private static final int ACTIVITY_RESULT_UPLOAD_SELECTED = 1;
    private static final int ACTIVITY_RESULT_UPLOAD_CONFIRMED = 2;
    private static final int REQUEST_READ_EXTERNAL_STORAGE = 1;
    private final NetworkConnectivityListener networkConnectivityListener = new NetworkConnectivityListener();
    private final Set<String> currentTypers = new HashSet<String>();
    private final List<Part> sendingFailures = new ArrayList<Part>();
    private Listener listener;
    private String conversationId;
    private ViewHolderGenerator generator;
    private RecyclerConversationAdapter adapter;
    private Blocks blocks;
    private List<Part> conversationParts;
    private BlocksViewHolder blocksUserViewHolder;
    private BlocksViewHolder blocksAnnouncementViewHolder;
    private BlocksViewHolder blocksAdminViewHolder;
    private View rootView;
    private ImageView wallpaper;
    private ComposerInputView textComposer;
    private ReactionInputView reactionComposer;
    private RecyclerView conversationList;
    private IntercomErrorView intercomErrorView;
    private TextView pill;
    private ProfileCoordinator presenceCardViewHolder;
    private LinearLayoutManager layoutManager;
    private LongTermImageLoader longTermImageLoader;
    private Conversation conversation;
    private LastParticipatingAdmin lastParticipant;
    private SpoolWrapper spool;
    private NetworkState networkState;
    private Future timestampUpdateFuture;
    private String lastActiveTime;
    private boolean canOpenProfile = true;
    @Nullable
    private Part markedPart = null;
    @Nullable
    private Part loadingPart = null;
    private Bus bus;
    private Api api;
    private NexusWrapper nexusClient;
    private IdentityStore identityStore;
    private TeamPresenceProvider teamPresenceProvider;
    private final Handler connectivityMonitor = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (ConversationFragment.this.networkState != ConversationFragment.this.networkConnectivityListener.getState()) {
                if (ConversationFragment.this.networkConnectivityListener.getState() == NetworkState.NOT_CONNECTED) {
                    Snackbar.make((View)ConversationFragment.this.rootView, (int)R.string.intercom_no_network_connection, (int)-2).show();
                } else if (ConversationFragment.this.networkConnectivityListener.getState() == NetworkState.CONNECTED && ConversationFragment.this.networkState == NetworkState.NOT_CONNECTED) {
                    Snackbar.make((View)ConversationFragment.this.rootView, (int)R.string.intercom_connected, (int)0).setActionTextColor(ConversationFragment.this.identityStore.getAppConfig().getBaseColor()).setAction(R.string.intercom_dismiss, new View.OnClickListener(){

                        public void onClick(View v) {
                        }
                    }).show();
                }
                ConversationFragment.this.networkState = ConversationFragment.this.networkConnectivityListener.getState();
            }
            return false;
        }
    });

    public static ConversationFragment newInstance(String conversationId, LastParticipatingAdmin participant, boolean isRead) {
        ConversationFragment frag = new ConversationFragment();
        Bundle args = new Bundle();
        args.putString(ARG_CONVERSATION_ID, conversationId);
        args.putParcelable(LAST_PARTICIPANT, (Parcelable)participant);
        args.putBoolean(ARG_IS_READ, isRead);
        frag.setArguments(args);
        return frag;
    }

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector.init(this.getActivity().getApplication());
        Injector injector = Injector.get();
        this.bus = injector.getBus();
        this.api = injector.getApi();
        this.nexusClient = injector.getNexusClient();
        this.identityStore = injector.getIdentityStore();
        this.teamPresenceProvider = injector.getTeamPresenceProvider();
        this.conversationParts = new ArrayList<Part>();
        this.generator = new ViewHolderGenerator(this.getActivity().getApplicationContext());
        this.blocksUserViewHolder = this.generator.getUserHolder();
        this.blocksAnnouncementViewHolder = this.generator.getContainerCardHolder();
        this.blocksAdminViewHolder = this.generator.getAdminHolder();
        Bundle args = this.getArguments();
        if (args != null) {
            boolean isRead;
            this.conversationId = args.getString(ARG_CONVERSATION_ID, "");
            this.lastParticipant = (LastParticipatingAdmin)args.getParcelable(LAST_PARTICIPANT);
            if (this.lastParticipant == null) {
                this.lastParticipant = LastParticipatingAdmin.NULL;
            }
            if (!(isRead = args.getBoolean(ARG_IS_READ, false))) {
                injector.getUnreadCountTracker().decrementCount();
            }
        }
        this.conversationParts = new ArrayList<Part>();
        this.conversation = new Conversation();
        this.spool = new SpoolWrapper((Context)this.getActivity());
        this.networkState = NetworkState.UNKNOWN;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercom_fragment_conversation, container, false);
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.pill = (TextView)this.rootView.findViewById(R.id.pill);
        this.pill.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.pill.setVisibility(8);
                ConversationFragment.this.conversationList.smoothScrollToPosition(ConversationFragment.this.adapter.getCount() - 1);
            }
        });
        this.presenceCardViewHolder = new ProfileCoordinator((CoordinatorLayout)this.rootView.findViewById(R.id.conversation_coordinator_layout));
        this.conversationList = (RecyclerView)this.rootView.findViewById(R.id.conversation_list);
        ((SimpleItemAnimator)this.conversationList.getItemAnimator()).setSupportsChangeAnimations(false);
        this.conversationList.setNestedScrollingEnabled(true);
        this.intercomErrorView = (IntercomErrorView)this.rootView.findViewById(R.id.error_layout);
        this.intercomErrorView.setActionButtonClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.displayLoadingView();
                ConversationFragment.this.api.getConversation(ConversationFragment.this.conversationId);
            }
        });
        this.blocks = new Blocks(this.getActivity().getApplicationContext());
        this.layoutManager = new LinearLayoutManager((Context)this.getActivity(), 1, false);
        this.conversationList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.conversationList.addItemDecoration((RecyclerView.ItemDecoration)new ConversationItemDecoration((Context)this.getActivity(), this.conversationParts));
        this.adapter = RecyclerConversationAdapter.create((Context)this.getActivity(), this.conversationParts, this);
        this.conversationList.setAdapter((RecyclerView.Adapter)this.adapter);
        this.bus.register((Object)this);
        this.updateProfileToolbar();
        this.wallpaper = (ImageView)this.rootView.findViewById(R.id.wallpaper);
        String wallpaperUrl = this.identityStore.getAppConfig().getWallpaper();
        this.longTermImageLoader = LongTermImageLoader.newInstance((Context)this.getActivity());
        this.longTermImageLoader.loadImage(wallpaperUrl, (Context)this.getActivity(), new LongTermImageLoader.OnImageReadyListener(){

            @Override
            public void onImageReady(Bitmap bitmap) {
                Bitmap finalBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)bitmap.getConfig());
                Canvas canvas = new Canvas(finalBitmap);
                canvas.drawARGB(255, 255, 255, 255);
                canvas.drawBitmap(bitmap, new Matrix(), null);
                int color2 = ConversationFragment.this.identityStore.getAppConfig().getBaseColor();
                canvas.drawARGB(12, Color.red((int)color2), Color.green((int)color2), Color.blue((int)color2));
                BitmapDrawable tiledWallpaper = new BitmapDrawable(ConversationFragment.this.getContext().getResources(), finalBitmap);
                tiledWallpaper.setTileModeX(Shader.TileMode.REPEAT);
                tiledWallpaper.setTileModeY(Shader.TileMode.REPEAT);
                ConversationFragment.this.wallpaper.setImageDrawable((Drawable)tiledWallpaper);
                BackgroundUtils.setBackground(ConversationFragment.this.rootView, null);
            }
        });
        this.textComposer = (ComposerInputView)this.rootView.findViewById(R.id.composer_input_view);
        this.reactionComposer = (ReactionInputView)this.rootView.findViewById(R.id.reaction_input_view);
        this.setupComposer();
        this.listener.setToolbarBackground(17170445);
        this.listener.setToolbarTitle(null);
        this.listener.setCountVisible();
        this.listener.setStatusBarColor();
        this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){
            private int previousHeight;

            public void onGlobalLayout() {
                int newHeight = ConversationFragment.this.rootView.getHeight();
                if (this.previousHeight != 0 && this.previousHeight > newHeight) {
                    int velocity = ConversationFragment.this.getResources().getDimensionPixelSize(R.dimen.intercom_close_velocity);
                    ConversationFragment.this.presenceCardViewHolder.flingCoordinator(velocity);
                }
                this.previousHeight = newHeight;
            }
        });
        this.conversationList.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0 && ConversationFragment.this.isAtBottom()) {
                    ConversationFragment.this.pill.setVisibility(8);
                }
            }
        });
        return this.rootView;
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        if (this.conversationId.isEmpty()) {
            this.canOpenProfile = false;
            view.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ConversationFragment.this.getActivity() == null) {
                        return;
                    }
                    int velocity = ConversationFragment.this.getResources().getDimensionPixelSize(R.dimen.intercom_open_velocity);
                    ConversationFragment.this.presenceCardViewHolder.flingCoordinator(velocity);
                    ConversationFragment.this.presenceCardViewHolder.startOffsetListener();
                }
            }, 50L);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        this.networkConnectivityListener.startListening((Context)this.getActivity());
        this.networkConnectivityListener.registerHandler(this.connectivityMonitor, 0);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.textComposer.updateMaxLines();
    }

    public void onStop() {
        super.onStop();
        this.networkConnectivityListener.unregisterHandler(this.connectivityMonitor);
        this.networkConnectivityListener.stopListening();
    }

    public void onDestroyView() {
        this.bus.unregister((Object)this);
        if (this.timestampUpdateFuture != null) {
            this.timestampUpdateFuture.cancel(true);
        }
        this.textComposer.hideKeyboard();
        this.textComposer.cleanup();
        try {
            this.longTermImageLoader.close();
        }
        catch (IOException e) {
            IntercomLogger.d("Couldn't close LongTermImageLoader: " + e.getMessage());
        }
        super.onDestroyView();
    }

    public void retryTapped() {
        if (this.markedPart == null) {
            return;
        }
        this.markedPart.setMessageState(Part.MessageState.SENDING);
        this.markedPart.setFooter(this.getString(R.string.intercomsdk_sending));
        this.conversationParts.remove(this.markedPart);
        this.conversationParts.add(this.conversationParts.size(), this.markedPart);
        this.adapter.notifyDataSetChanged();
        String partText = this.markedPart.getBlocks().get(0).getText();
        if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
            this.startConversation(partText, this.markedPart.getId());
        } else {
            this.replyToConversation(partText, this.markedPart, this.conversationParts.size() - 1);
        }
        this.markedPart = null;
    }

    private void sendTapped() {
        String text = this.textComposer.getTrimmedText();
        if (!text.isEmpty()) {
            Part message = this.createSendingUi(text);
            this.spool.playReplySendingSound();
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.startConversation(text, message.getId());
            } else {
                this.replyToConversation(text, message, this.conversationParts.size() - 1);
            }
            this.textComposer.clear();
            this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
        }
    }

    private void attachmentTapped() {
        if (DeviceUtils.hasPermission((Context)this.getActivity(), (String)"android.permission.READ_EXTERNAL_STORAGE") || Build.VERSION.SDK_INT == 15) {
            this.launchContentSelector();
        } else if (Build.VERSION.SDK_INT > 22) {
            this.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 1);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 1) {
            if (grantResults[0] == 0) {
                this.launchContentSelector();
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (-1 == resultCode) {
            switch (requestCode) {
                case 1: {
                    Intent intent = new Intent((Context)this.getActivity(), AttachmentActivity.class);
                    intent.setData(data.getData());
                    this.startActivityForResult(intent, 2);
                    break;
                }
                case 2: {
                    this.uploadFile(data.getData(), "");
                    break;
                }
                default: {
                    IntercomLogger.internal("Unexpected request code");
                }
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    private void launchContentSelector() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        this.startActivityForResult(intent, 1);
    }

    private void uploadFile(Uri uri, String id2) {
        if (uri != null) {
            new LoadFileTask().execute(new Object[]{uri, id2});
        }
    }

    private Part createAttachmentBlock(String name, String url, String contentType, int width, int height, Uri fileUri) {
        ArrayList<BlockAttachment> attachments = new ArrayList<BlockAttachment>();
        ArrayList<Block> blockParts = new ArrayList<Block>();
        Participant user = this.getParticipant();
        Part message = new Part();
        if (contentType.contains(Image.MIME_TYPE)) {
            Block block = new Block.Builder().withUrl(url).withType(BlockType.LOCALIMAGE.name()).withWidth(width).withHeight(height).build();
            blockParts.add(block);
            message.isImageOnly(true);
        } else {
            BlockAttachment blockAttachment = new BlockAttachment.Builder().withName(name).withUrl(url).withContentType(contentType).build();
            attachments.add(blockAttachment);
            Block block = new Block.Builder().withAttachments(attachments).withType(BlockType.LOCAL_ATTACHMENT.name()).build();
            blockParts.add(block);
        }
        message.setMessageStyle("chat");
        message.setMessageState(Part.MessageState.SENDING);
        message.setParticipant(user);
        message.setBlocks(blockParts);
        message.setFooter(this.getString(R.string.intercomsdk_sending));
        message.setCreatedAt(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        message.setLayout(this.blocks.createBlocks(blockParts, this.generator.getPreviewHolder()));
        message.setAttachments(new ArrayList<Attachments>());
        message.setId(UUID.randomUUID().toString());
        message.setEntranceAnimation(true);
        message.setShowCreatedAt(true);
        message.setFileUri(fileUri);
        this.conversationParts.add(this.conversationParts.size(), message);
        this.sendingFailures.add(message);
        this.adapter.notifyDataSetChanged();
        this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
        return message;
    }

    private void setupComposer() {
        this.textComposer.requestInputFocus();
        this.configureInputView(this.conversation);
        if (this.conversationId.isEmpty()) {
            this.conversationList.setVisibility(0);
            this.textComposer.setHint(R.string.intercomsdk_start_new_conversation);
            this.displayConversation();
        } else {
            this.textComposer.setConversationId(this.conversationId);
            this.api.getConversation(this.conversationId);
            this.displayLoadingView();
        }
    }

    private void displayLoadingView() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(8);
            this.textComposer.setVisibility(8);
            this.loadingPart = new Part.Builder().withStyle("loading_layout_style").build();
            this.conversationParts.add(0, this.loadingPart);
            this.adapter.notifyItemInserted(0);
        }
    }

    @VisibleForTesting
    protected void displayConversation() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(8);
            this.removeLoadingPart();
            this.configureInputView(this.conversation);
        }
    }

    private void displayErrorView() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(0);
            this.textComposer.setVisibility(4);
            this.removeLoadingPart();
        }
    }

    private void removeLoadingPart() {
        int index = this.conversationParts.indexOf(this.loadingPart);
        if (index != -1) {
            this.conversationParts.remove(index);
            this.adapter.notifyItemRemoved(index);
        }
    }

    private void startConversation(String text, String partId) {
        this.api.startNewConversation(text, this.conversationParts.size() - 1, partId);
    }

    private void startConversationWithAttachment(int uploadId, String partId) {
        this.api.startNewAttachmentConversation(uploadId, this.conversationParts.size() - 1, partId);
    }

    private void replyToConversation(String text, Part part, int partPosition) {
        this.api.textReply(this.conversationId, text, partPosition, part.getId());
    }

    private void attachmentToConversation(Part part, int partPosition, int uploadId) {
        this.api.attachmentReply(this.conversationId, uploadId, partPosition, part.getId());
    }

    @Subscribe
    public void conversationSuccess(ConversationEvent event) {
        int conversationSize = this.conversation.getParts().size();
        List<Part> eventParts = event.getResponse().getParts();
        if (!eventParts.isEmpty() && eventParts.get(0).isAdmin()) {
            eventParts.get(0).setFirstChatPart(true);
        }
        if (event.getResponse().getId().equals(this.conversationId) && eventParts.size() > conversationSize) {
            this.conversation = event.getResponse();
            if (this.isAdded()) {
                this.setupWithConversation();
            }
            if (!this.conversation.getRead().booleanValue()) {
                this.markAsRead();
                this.nexusClient.fire(NexusEvent.getConversationSeenEvent((String)this.conversationId, (String)this.identityStore.getIntercomId()));
            }
            if (conversationSize == 0) {
                View view;
                if (this.conversation.getParts().get(this.conversation.getParts().size() - 1).isFirstChatPart()) {
                    this.layoutManager.scrollToPosition(0);
                } else {
                    this.layoutManager.scrollToPosition(this.adapter.getCount() - 1);
                }
                if (this.canOpenProfile && (view = this.getView()) != null) {
                    view.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationFragment.this.isAtTop() && ConversationFragment.this.canExpandProfile() && "chat".equals(ConversationFragment.this.conversation.getParts().get(0).getMessageStyle())) {
                                ConversationFragment.this.presenceCardViewHolder.flingCoordinator(ConversationFragment.this.getResources().getDimensionPixelSize(R.dimen.intercom_open_velocity));
                                ConversationFragment.this.presenceCardViewHolder.startOffsetListener();
                            } else {
                                ConversationFragment.this.presenceCardViewHolder.startOffsetListener();
                            }
                        }
                    }, 50L);
                }
                this.canOpenProfile = false;
            } else {
                List<Part> newParts = eventParts.subList(conversationSize, eventParts.size());
                for (Part p : newParts) {
                    if (!p.isAdmin()) continue;
                    this.spool.playAdminReplySound();
                    break;
                }
                if (this.isAtBottom()) {
                    this.conversationList.scrollToPosition(this.adapter.getCount() - 1);
                } else {
                    this.pill.setVisibility(8);
                }
                this.bus.post((Object)new CancelAdminTypingEvent());
                this.currentTypers.clear();
            }
        }
        this.lastParticipant = this.conversation.getLastParticipatingAdmin();
        this.updateLastActiveTime(this.conversation);
        this.updateProfileToolbar();
    }

    private void updateLastActiveTime(long time) {
        LastParticipatingAdmin lastAdmin = this.conversation.getLastParticipatingAdmin();
        if (lastAdmin != null) {
            this.lastActiveTime = TimeUtils.getAdminActiveStatus(time, this.getResources());
        }
    }

    private void updateLastActiveTime(Conversation conversation) {
        LastParticipatingAdmin lastAdmin = conversation.getLastParticipatingAdmin();
        if (lastAdmin != null) {
            this.updateLastActiveTime(lastAdmin.getLastActiveAt());
        }
    }

    @Subscribe
    public void onUserContentSeenByAdmin(UserContentSeenByAdminEvent event) {
        if (event.getConversationId().equals(this.conversationId) && this.conversationParts != null && !this.conversationParts.isEmpty()) {
            boolean markedAsSeen = false;
            for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
                Part part = this.conversationParts.get(i);
                if (!markedAsSeen && !part.isAdmin()) {
                    part.setSeenByAdmin("seen");
                    markedAsSeen = true;
                    continue;
                }
                part.setSeenByAdmin("hide");
            }
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void conversationFailure(ConversationFailedEvent event) {
        this.displayErrorView();
    }

    @Subscribe
    public void newConversationSuccess(NewConversationEvent event) {
        if (!this.conversationParts.isEmpty() && this.conversationParts.get(this.conversationParts.size() - 1).getId().equals(event.getIdentifier())) {
            this.conversation = event.getResponse();
            this.conversationId = this.conversation.getId();
            this.conversationParts.remove(this.conversationParts.size() - 1);
            this.sendingFailures.clear();
            Part newPart = this.createMessageUi(event.getResponse().getParts().get(0));
            this.conversationParts.add(newPart);
            this.textComposer.setConversationId(this.conversationId);
            this.nexusClient.fire(NexusEvent.getCreateConversationEvent((String)this.conversationId, (String)this.identityStore.getIntercomId()));
            this.spool.playReplySuccessSound();
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void newConversationFailure(NewConversationFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), false);
    }

    @Subscribe
    public void replySuccess(ReplyEvent event) {
        if (event.getConversationId().equals(this.conversationId)) {
            this.nexusClient.fire(NexusEvent.getNewCommentEvent((String)this.conversationId, (String)this.identityStore.getIntercomId()));
            Part response = event.getResponse();
            Participant participant = this.conversation.getParticipant(response.getParticipantId());
            if (Participant.isNull(participant)) {
                participant = new Participant.Builder().withId(response.getParticipantId()).build();
                this.conversation.getParticipants().put(response.getParticipantId(), participant);
            }
            response.setParticipant(participant);
            int position = this.positionOfTempPart(event.getPosition(), event.getPartId());
            if (position >= 0) {
                this.sendingFailures.remove(this.conversationParts.remove(position));
            }
            final Part newPart = this.createMessageUi(response);
            newPart.setDisplayDelivered(true);
            this.conversationParts.add(this.conversationParts.size(), newPart);
            this.adapter.notifyDataSetChanged();
            this.spool.playReplySuccessSound();
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    newPart.setDisplayDelivered(false);
                    ConversationFragment.this.adapter.notifyDataSetChanged();
                }
            }, TimeUnit.MINUTES.toMillis(1L));
        }
    }

    @Subscribe
    public void replyFailure(ReplyFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), event.isUpload());
        this.spool.playReplyFailSound();
    }

    @Subscribe
    public void uploadSuccess(UploadEvent event) {
        int partPosition = this.positionOfTempPart(event.getTempPartPosition(), event.getTempPartId());
        if (partPosition >= 0) {
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.startConversationWithAttachment(event.getUploadId(), event.getTempPartId());
            } else {
                this.attachmentToConversation(this.conversationParts.get(partPosition), partPosition, event.getUploadId());
            }
        }
    }

    @Subscribe
    public void uploadFailure(UploadFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), true);
        this.spool.playReplyFailSound();
    }

    private void markAsFailed(int position, String partId, boolean uploadFailed) {
        int partPosition = this.positionOfTempPart(position, partId);
        if (partPosition >= 0) {
            Part failedPart = this.conversationParts.get(partPosition);
            failedPart.setMessageState(uploadFailed ? Part.MessageState.UPLOAD_FAILED : Part.MessageState.FAILED);
            failedPart.setFooter(this.getString(R.string.intercomsdk_sending_failure));
            this.adapter.notifyDataSetChanged();
        }
    }

    private int positionOfTempPart(int position, String partId) {
        if (position >= 0 && position < this.conversationParts.size()) {
            Part sendingPart = this.conversationParts.get(position);
            if (sendingPart.getId().equals(partId)) {
                return position;
            }
            for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
                if (!this.conversationParts.get(i).getId().equals(partId)) continue;
                return i;
            }
        }
        return -1;
    }

    private void setupWithConversation() {
        this.textComposer.setHint(R.string.intercomsdk_reply_to_conversation);
        this.createConversationUi(this.conversation.getParts());
        this.updateTimeStampScheduler();
    }

    private void configureInputView(Conversation conversation) {
        Part lastPart = conversation.getLastPart();
        if (ReactionReply.isNull(lastPart.getReactionReply())) {
            this.textComposer.setVisibility(0);
            this.reactionComposer.setVisibility(8);
            this.textComposer.requestInputFocus();
        } else {
            this.reactionComposer.setUpReactions(lastPart.getReactionReply(), conversation.getId(), true);
            this.textComposer.setVisibility(8);
        }
    }

    private void createConversationUi(List<Part> parts) {
        this.conversationParts.clear();
        for (Part part : parts) {
            if (part.getLayout() == null) {
                part = this.createMessageUi(part);
            }
            this.conversationParts.add(this.conversationParts.size(), part);
        }
        this.conversationParts.addAll(this.sendingFailures);
        TimeStampGroup.addDayDividers(this.conversationParts);
        this.adapter.notifyDataSetChanged();
        this.displayConversation();
        this.lastParticipant = this.conversation.getLastParticipatingAdmin();
        this.updateLastActiveTime(this.conversation);
        this.updateProfileToolbar();
    }

    private boolean canExpandProfile() {
        View lastChild = this.conversationList.getChildAt(this.adapter.getCount() - 1);
        return this.isAdded() && lastChild != null && this.conversationList.getBottom() - lastChild.getBottom() > this.presenceCardViewHolder.getAppBarLayout().getTotalScrollRange() + this.getResources().getDimensionPixelSize(R.dimen.intercom_toolbar_height);
    }

    public void toggleProfile() {
        if (this.presenceCardViewHolder.isExpanded()) {
            int velocity = this.getResources().getDimensionPixelSize(R.dimen.intercom_close_velocity);
            this.presenceCardViewHolder.flingCoordinator(velocity);
        } else {
            int velocity = this.getResources().getDimensionPixelSize(R.dimen.intercom_open_velocity);
            this.presenceCardViewHolder.flingCoordinator(velocity);
            this.presenceCardViewHolder.trackOpenMetric(this.conversationId);
        }
    }

    private Part createSendingUi(String text) {
        ArrayList<Block> blockParts = new ArrayList<Block>();
        Block block = new Block.Builder().withText(text).withType(BlockType.PARAGRAPH.name()).build();
        blockParts.add(block);
        Participant user = this.getParticipant();
        Part message = new Part();
        message.setMessageStyle("chat");
        message.setMessageState(Part.MessageState.SENDING);
        message.setParticipant(user);
        message.setBlocks(blockParts);
        message.setFooter(this.getString(R.string.intercomsdk_sending));
        message.setCreatedAt(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        message.setLayout(this.blocks.createBlocks(blockParts, this.generator.getPreviewHolder()));
        message.setAttachments(new ArrayList<Attachments>());
        message.setId(UUID.randomUUID().toString());
        message.setEntranceAnimation(true);
        message.setShowCreatedAt(true);
        this.conversationParts.add(this.conversationParts.size(), message);
        this.sendingFailures.add(message);
        this.adapter.notifyDataSetChanged();
        return message;
    }

    private void updateProfileToolbar() {
        if (LastParticipatingAdmin.isNull(this.lastParticipant)) {
            this.showTeamPresence();
        } else {
            this.updateLastActiveTime(this.lastParticipant.getLastActiveAt());
            this.presenceCardViewHolder.setTeamMatePresence(this.lastParticipant, this.lastActiveTime, this.getContext());
        }
    }

    private void updateTimeStampScheduler() {
        this.timestampUpdateFuture = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ConversationFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ConversationFragment.this.adapter.notifyDataSetChanged();
                    }
                });
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }

    private Participant getParticipant() {
        String intercomId = this.identityStore.getIntercomId();
        Participant user = this.conversation.getParticipant(intercomId);
        if (Participant.isNull(user)) {
            user = new Participant.Builder().withId(intercomId).build();
        }
        return user;
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        if (event.getConversationId().equals(this.conversationId)) {
            this.api.getConversation(this.conversationId);
        }
    }

    @Subscribe
    public void adminIsTyping(AdminIsTypingEvent event) {
        if (this.conversationId.equals(event.getConversationId()) && !this.currentTypers.contains(event.getAdminId())) {
            Part isTypingPart = new Part();
            Participant participant = this.conversation.getParticipant(event.getAdminId());
            if (Participant.isNull(participant)) {
                participant = new Participant.Builder().withId(event.getAdminId()).withName(event.getAdminName()).withAvatar(new Avatar.Builder().withImageUrl(event.getAdminAvatarUrl())).withType("admin").build();
            }
            isTypingPart.setParticipantIsAdmin(true);
            isTypingPart.setParticipant(participant);
            isTypingPart.setMessageStyle("admin_is_typing_style");
            isTypingPart.setId(UUID.randomUUID().toString());
            isTypingPart.setEntranceAnimation(true);
            LinearLayout contentLayout = (LinearLayout)View.inflate((Context)this.getActivity().getApplicationContext(), (int)R.layout.intercom_blocks_admin_layout, null);
            AdminIsTypingView adminIsTypingView = new AdminIsTypingView(this.getActivity().getApplicationContext(), event.getAdminId(), this.conversationId, isTypingPart.getId());
            contentLayout.addView((View)adminIsTypingView);
            isTypingPart.setLayout(contentLayout);
            boolean wasAtBottom = this.isAtBottom();
            int index = this.conversationParts.isEmpty() ? 0 : this.conversationParts.size();
            this.conversationParts.add(index, isTypingPart);
            this.adapter.notifyDataSetChanged();
            this.currentTypers.add(event.getAdminId());
            if (wasAtBottom) {
                this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
            }
        }
    }

    @Subscribe
    public void adminIsntTyping(AdminTypingEndedEvent event) {
        int position = this.positionOfTempPart(this.conversationParts.size() - 1, event.getPartId());
        if (position >= 0) {
            this.currentTypers.remove(event.getAdminId());
            this.conversationParts.remove(position);
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void sendMessage(SendingEvent event) {
        if (event.isAttachment()) {
            this.attachmentTapped();
        } else {
            this.sendTapped();
        }
    }

    private boolean isAtBottom() {
        return this.layoutManager.findLastCompletelyVisibleItemPosition() >= this.conversationParts.size() - 1;
    }

    private boolean isAtTop() {
        return this.layoutManager.findFirstCompletelyVisibleItemPosition() == 0;
    }

    @Override
    public void onPartClicked(Part part) {
        if (part.getMessageState() == Part.MessageState.FAILED) {
            this.markedPart = part;
            this.listener.showErrorMessageDialog();
        } else if (part.getMessageState() == Part.MessageState.UPLOAD_FAILED) {
            part.setMessageState(Part.MessageState.SENDING);
            part.setFooter(this.getString(R.string.intercomsdk_sending));
            this.conversationParts.remove(this.conversationParts.indexOf(part));
            this.conversationParts.add(this.conversationParts.size(), part);
            this.adapter.notifyDataSetChanged();
            this.uploadFile(part.getFileUri(), part.getId());
        }
    }

    private void showTeamPresence() {
        Resources res = this.getResources();
        this.presenceCardViewHolder.setTeamCollapsingTitle(String.format(res.getString(R.string.intercom_team), this.identityStore.getAppConfig().getName()));
        if (this.teamPresenceProvider.hasTeamPresence()) {
            this.presenceCardViewHolder.setTeamPresence(this.teamPresenceProvider.getTeamPresence());
        } else {
            this.presenceCardViewHolder.setCollapsingSubtitle(null);
        }
    }

    @Override
    public void onSupportAttach(Context context) {
        super.onSupportAttach(context);
        try {
            this.listener = (Listener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement ConversationFragment.Listener");
        }
    }

    private Part createMessageUi(Part part) {
        Participant user = part.getParticipant();
        List<Block> blockParts = part.getBlocks();
        if (!part.getAttachments().isEmpty()) {
            ArrayList<BlockAttachment> blockAttachments = new ArrayList<BlockAttachment>();
            for (Attachments attachment : part.getAttachments()) {
                blockAttachments.add(new BlockAttachment.Builder().withName(attachment.getName()).withUrl(attachment.getUrl()).withContentType(attachment.getContentType()).build());
            }
            Block attachmentBlock = new Block.Builder().withType(BlockType.ATTACHMENTLIST.name()).withAttachments(blockAttachments).build();
            blockParts.add(attachmentBlock);
        }
        if ("user".equals(user.getType()) && user.getId().equals(this.identityStore.getIntercomId())) {
            part.setLayout(this.blocks.createBlocks(blockParts, this.blocksUserViewHolder));
        } else if ("post".equals(part.getMessageStyle()) || "note".equals(part.getMessageStyle())) {
            part.setLayout(this.blocks.createBlocks(blockParts, this.blocksAnnouncementViewHolder));
        } else {
            part.setLayout(this.blocks.createBlocks(blockParts, this.blocksAdminViewHolder));
        }
        return part;
    }

    private void markAsRead() {
        this.api.markConversationAsRead(this.conversationId);
    }

    public static interface Listener {
        public void setToolbarTitle(String var1);

        public void setToolbarBackground(@ColorRes int var1);

        public void showErrorMessageDialog();

        public void setCountVisible();

        public void setStatusBarColor();
    }

    private class LoadFileTask
    extends AsyncTask<Object, Void, AttachmentData> {
        private LoadFileTask() {
        }

        protected AttachmentData doInBackground(Object ... params) {
            return new AttachmentData((Uri)params[0], (String)params[1], (Activity)ConversationFragment.this.getActivity());
        }

        protected void onPostExecute(AttachmentData data) {
            UploadProgressListener listener;
            String id2 = data.getId();
            if (id2.isEmpty()) {
                Part message = ConversationFragment.this.createAttachmentBlock(data.getFileName(), data.getPath(), data.getMimeType(), data.getImageWidth(), data.getImageHeight(), data.getUri());
                ConversationFragment.this.spool.playReplySendingSound();
                id2 = message.getId();
                listener = (UploadProgressListener)message.getLayout().getChildAt(0);
            } else {
                int i = ConversationFragment.this.positionOfTempPart(ConversationFragment.this.conversationParts.size() - 1, id2);
                listener = i >= 0 ? (UploadProgressListener)((Part)ConversationFragment.this.conversationParts.get(i)).getLayout().getChildAt(0) : new UploadProgressListener(){

                    @Override
                    public void uploadNotice(byte percentUploaded) {
                    }
                };
            }
            ConversationFragment.this.api.uploadFile(data.getFile(), data.getFileName(), data.getSize(), data.getMimeType(), data.getImageWidth(), data.getImageHeight(), ConversationFragment.this.conversationParts.size() - 1, id2, listener, (Context)ConversationFragment.this.getActivity());
        }
    }
}

