/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.text.Spanned;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.ParagraphBlock;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;

public class Paragraph
implements ParagraphBlock {
    private final LayoutInflater inflater;
    private final StyleType style;

    public Paragraph(LayoutInflater inflater, StyleType style) {
        this.style = style;
        this.inflater = inflater;
    }

    public View addParagraph(Spanned text, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview;
        switch (this.style) {
            case ADMIN: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_admin_paragraph, parent, false);
                break;
            }
            case NOTE: 
            case CONTAINER_CARD: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_note_paragraph, parent, false);
                break;
            }
            case POST: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_post_paragraph, parent, false);
                break;
            }
            default: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_user_paragraph, parent, false);
            }
        }
        if (StyleType.ADMIN == this.style || StyleType.NOTE == this.style || StyleType.CONTAINER_CARD == this.style) {
            textview.setLinkTextColor(Injector.get().getIdentityStore().getAppConfig().getBaseColor());
        } else if (StyleType.POST == this.style) {
            textview.setLinkTextColor(ColorUtils.lightenColor(Injector.get().getIdentityStore().getAppConfig().getBaseColor()));
        }
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        if (StyleType.PREVIEW == this.style) {
            textview.setText((CharSequence)text.toString());
        } else {
            textview.setText((CharSequence)text);
        }
        textview.setGravity(alignment.getGravity());
        BlockUtils.setLayoutMarginsAndGravity((View)textview, alignment.getGravity(), isLastObject);
        textview.setClickable(false);
        textview.setFocusable(false);
        return textview;
    }
}

